/* A Bison parser, made by GNU Bison 2.3.  */

/* Skeleton implementation for Bison's Yacc-like parsers in C

   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004, 2005, 2006
   Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "2.3"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ERROR = 258,
     RANGE = 259,
     RESERVE = 260,
     ATTR = 261,
     OPERATOR = 262,
     CTO = 263,
     LTO = 264,
     RTO = 265,
     BITS = 266,
     IMPLICIT = 267,
     IMPORT = 268,
     PROVIDE = 269,
     OPTION = 270,
     IDR = 271,
     INT = 272,
     STRING = 273
   };
#endif
/* Tokens.  */
#define ERROR 258
#define RANGE 259
#define RESERVE 260
#define ATTR 261
#define OPERATOR 262
#define CTO 263
#define LTO 264
#define RTO 265
#define BITS 266
#define IMPLICIT 267
#define IMPORT 268
#define PROVIDE 269
#define OPTION 270
#define IDR 271
#define INT 272
#define STRING 273




/* Copy the first part of user declarations.  */
#line 1 "cuex-otab.y"


#include <cu/idr.h>
#include <cu/sref.h>
#include <cu/str.h>
#include <cu/clos.h>
#include <cuos/file.h>
#include <cuos/fs.h>
#include <cucon/pmap.h>
#include <cucon/list.h>
#include <cucon/bitvect.h>
#include <cuex/otab.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include <stdio.h>
#include <ctype.h>
#include <argp.h>
#include <errno.h>

typedef struct ot_intrange *ot_intrange_t;
typedef struct ot_state *ot_state_t;
typedef union ot_value *ot_value_t;

struct ot_intrange
{
    cuex_meta_t min;
    cuex_meta_t maxp1;
};

struct ot_state
{
    cuex_otab_t otab;
    struct cu_sref sref;
    FILE *in;
    cu_bool_t is_extern;
    int error_cnt;
    cuex_otab_range_t current_range;
    cucon_list_t import_paths;
};

int ot_parse_file(cuex_otab_t tab, cu_str_t path, cucon_list_t import_paths);

void ot_state_import(ot_state_t state, cu_sref_t sref, cu_str_t path);

cuex_otab_range_t
ot_state_defrange(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		  cu_idr_t super, ot_intrange_t intrange);
void ot_state_defopr(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		     int r, cu_bool_t has_ctor, cu_idr_t range_idr);
void ot_state_defprop(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		      unsigned int bits, cu_str_t type_str,
		      cu_bool_t is_implicit);
void ot_state_reserve(ot_state_t state, cu_sref_t sref, cu_idr_t super_idr,
		      ot_intrange_t r);
void ot_state_defoption(ot_state_t state, cu_sref_t sref,
			cu_idr_t idr, cu_str_t str);

static int yylex(ot_value_t val_out, cu_sref_t loc_out, ot_state_t state);
static void yyerror(cu_sref_t loc, ot_state_t state, char const *msg);

#define YYLTYPE struct cu_sref
#define YYLLOC_DEFAULT(lhs, rhs, n)					\
    do {								\
	if (n)								\
	    cu_sref_cct_sref_range(&(lhs),				\
		&YYRHSLOC(rhs, 1), &YYRHSLOC(rhs, n));			\
	else								\
	    cu_sref_cct_sref_last(&(lhs), &YYRHSLOC(rhs, 0));		\
    } while (0)



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

/* Enabling the token table.  */
#ifndef YYTOKEN_TABLE
# define YYTOKEN_TABLE 0
#endif

#if ! defined YYSTYPE && ! defined YYSTYPE_IS_DECLARED
typedef union
#line 82 "cuex-otab.y"
ot_value {
    int i;
    cu_idr_t idr;
    ot_intrange_t intrange;
    cu_str_t str;
    struct { int r; cu_bool_t has_ctor; } opr;
}
/* Line 187 of yacc.c.  */
#line 215 "cuex/cuex-otab.c"
	YYSTYPE;
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined YYLTYPE && ! defined YYLTYPE_IS_DECLARED
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 216 of yacc.c.  */
#line 240 "cuex/cuex-otab.c"

#ifdef short
# undef short
#endif

#ifdef YYTYPE_UINT8
typedef YYTYPE_UINT8 yytype_uint8;
#else
typedef unsigned char yytype_uint8;
#endif

#ifdef YYTYPE_INT8
typedef YYTYPE_INT8 yytype_int8;
#elif (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
typedef signed char yytype_int8;
#else
typedef short int yytype_int8;
#endif

#ifdef YYTYPE_UINT16
typedef YYTYPE_UINT16 yytype_uint16;
#else
typedef unsigned short int yytype_uint16;
#endif

#ifdef YYTYPE_INT16
typedef YYTYPE_INT16 yytype_int16;
#else
typedef short int yytype_int16;
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif ! defined YYSIZE_T && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned int
# endif
#endif

#define YYSIZE_MAXIMUM ((YYSIZE_T) -1)

#ifndef YY_
# if YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(msgid) dgettext ("bison-runtime", msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(msgid) msgid
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(e) ((void) (e))
#else
# define YYUSE(e) /* empty */
#endif

/* Identity function, used to suppress warnings about constant conditions.  */
#ifndef lint
# define YYID(n) (n)
#else
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static int
YYID (int i)
#else
static int
YYID (i)
    int i;
#endif
{
  return i;
}
#endif

#if ! defined yyoverflow || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#     ifndef _STDLIB_H
#      define _STDLIB_H 1
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (YYID (0))
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined _STDLIB_H \
       && ! ((defined YYMALLOC || defined malloc) \
	     && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef _STDLIB_H
#    define _STDLIB_H 1
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined _STDLIB_H && (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* ! defined yyoverflow || YYERROR_VERBOSE */


#if (! defined yyoverflow \
     && (! defined __cplusplus \
	 || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
	     && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yytype_int16 yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (yytype_int16) + sizeof (YYSTYPE) + sizeof (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  YYSIZE_T yyi;				\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (YYID (0))
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (YYID (0))

#endif

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  4
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   66

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  27
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  13
/* YYNRULES -- Number of rules.  */
#define YYNRULES  28
/* YYNRULES -- Number of states.  */
#define YYNSTATES  67

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   273

#define YYTRANSLATE(YYX)						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const yytype_uint8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,    25,    23,     2,    24,     2,    26,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    22,     2,
       2,    19,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    20,     2,    21,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const yytype_uint8 yyprhs[] =
{
       0,     0,     3,     4,    10,    11,    14,    17,    18,    21,
      22,    32,    38,    43,    48,    49,    57,    66,    68,    69,
      71,    75,    79,    82,    84,    88,    92,    96,   100
};

/* YYRHS -- A `-1'-separated list of the rules' RHS.  */
static const yytype_int8 yyrhs[] =
{
      28,     0,    -1,    -1,    14,    18,    29,    30,    32,    -1,
      -1,    30,    31,    -1,    13,    18,    -1,    -1,    32,    33,
      -1,    -1,     4,    16,    19,    16,    20,    39,    21,    34,
      35,    -1,     5,    16,    20,    39,    21,    -1,     7,    16,
      22,    16,    -1,    15,    16,    19,    18,    -1,    -1,    35,
       6,    16,    22,    17,    11,    36,    -1,    35,    12,     6,
      16,    22,    17,    11,    36,    -1,    18,    -1,    -1,    38,
      -1,    37,    23,    38,    -1,    37,    24,    38,    -1,    24,
      38,    -1,    17,    -1,    38,    25,    17,    -1,    38,    26,
      17,    -1,    37,     8,    37,    -1,    37,     9,    37,    -1,
      37,    10,    37,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const yytype_uint8 yyrline[] =
{
       0,   116,   116,   116,   119,   121,   125,   128,   130,   135,
     134,   138,   140,   142,   146,   148,   150,   154,   154,   157,
     158,   159,   160,   164,   165,   166,   170,   176,   182
};
#endif

#if YYDEBUG || YYERROR_VERBOSE || YYTOKEN_TABLE
/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ERROR", "\"range\"", "\"reserve\"",
  "\"attr\"", "OPERATOR", "\"..\"", "\".!\"", "\"!.\"", "\"bits\"",
  "\"implicit\"", "\"import\"", "\"provide\"", "\"option\"", "IDR", "INT",
  "STRING", "'='", "'['", "']'", "':'", "'+'", "'-'", "'*'", "'/'",
  "$accept", "grammar", "@1", "prestmt_seq", "prestmt", "stmt_seq", "stmt",
  "@2", "prop_seq", "string_opt", "int_expr", "times_expr", "intrange", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const yytype_uint16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,    61,
      91,    93,    58,    43,    45,    42,    47
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const yytype_uint8 yyr1[] =
{
       0,    27,    29,    28,    30,    30,    31,    32,    32,    34,
      33,    33,    33,    33,    35,    35,    35,    36,    36,    37,
      37,    37,    37,    38,    38,    38,    39,    39,    39
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const yytype_uint8 yyr2[] =
{
       0,     2,     0,     5,     0,     2,     2,     0,     2,     0,
       9,     5,     4,     4,     0,     7,     8,     1,     0,     1,
       3,     3,     2,     1,     3,     3,     3,     3,     3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,     0,     0,     2,     1,     4,     7,     0,     5,     3,
       6,     0,     0,     0,     0,     8,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    23,     0,     0,    19,     0,
      12,    13,     0,    22,     0,     0,     0,     0,     0,     0,
       0,    11,     0,    26,    27,    28,    20,    21,    24,    25,
       9,    14,    10,     0,     0,     0,     0,     0,     0,     0,
       0,    18,     0,    17,    15,    18,    16
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
      -1,     2,     5,     6,     8,     9,    15,    51,    52,    64,
      27,    28,    29
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -33
static const yytype_int8 yypact[] =
{
      -2,    -4,    20,   -33,   -33,   -33,    11,     9,   -33,     4,
     -33,    12,    13,    14,    15,   -33,    16,    17,    10,    19,
      18,   -14,    23,    22,    21,   -33,    25,    -8,   -21,    24,
     -33,   -33,   -14,   -21,   -14,   -14,   -14,    25,    25,    26,
      27,   -33,    28,     2,     2,     2,   -21,   -21,   -33,   -33,
     -33,   -33,     1,    30,    41,    29,    32,    33,    31,    43,
      35,    37,    45,   -33,   -33,    37,   -33
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -33,   -33,   -33,   -33,   -33,   -33,   -33,   -33,   -33,   -32,
     -13,   -20,    34
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const yytype_uint8 yytable[] =
{
      34,    35,    36,    25,    39,    40,    33,    53,    11,    12,
      26,    13,     1,    54,     3,    37,    38,    46,    47,    14,
       4,    43,    44,    45,     7,    37,    38,    10,    16,    17,
      18,    19,    22,    66,    24,    20,     0,    21,    23,    30,
      31,    32,    25,    48,    49,    41,    55,    56,    58,    50,
      59,    57,    62,    60,    61,    63,    65,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    42
};

static const yytype_int8 yycheck[] =
{
       8,     9,    10,    17,    25,    26,    26,     6,     4,     5,
      24,     7,    14,    12,    18,    23,    24,    37,    38,    15,
       0,    34,    35,    36,    13,    23,    24,    18,    16,    16,
      16,    16,    22,    65,    16,    19,    -1,    20,    19,    16,
      18,    20,    17,    17,    17,    21,    16,     6,    16,    21,
      17,    22,    17,    22,    11,    18,    11,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    32
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    14,    28,    18,     0,    29,    30,    13,    31,    32,
      18,     4,     5,     7,    15,    33,    16,    16,    16,    16,
      19,    20,    22,    19,    16,    17,    24,    37,    38,    39,
      16,    18,    20,    38,     8,     9,    10,    23,    24,    25,
      26,    21,    39,    37,    37,    37,    38,    38,    17,    17,
      21,    34,    35,     6,    12,    16,     6,    22,    16,    17,
      22,    11,    17,    18,    36,    11,    36
};

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK (1);						\
      goto yybackup;						\
    }								\
  else								\
    {								\
      yyerror (&yylloc, state, YY_("syntax error: cannot back up")); \
      YYERROR;							\
    }								\
while (YYID (0))


#define YYTERROR	1
#define YYERRCODE	256


/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#define YYRHSLOC(Rhs, K) ((Rhs)[K])
#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)				\
    do									\
      if (YYID (N))                                                    \
	{								\
	  (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;	\
	  (Current).first_column = YYRHSLOC (Rhs, 1).first_column;	\
	  (Current).last_line    = YYRHSLOC (Rhs, N).last_line;		\
	  (Current).last_column  = YYRHSLOC (Rhs, N).last_column;	\
	}								\
      else								\
	{								\
	  (Current).first_line   = (Current).last_line   =		\
	    YYRHSLOC (Rhs, 0).last_line;				\
	  (Current).first_column = (Current).last_column =		\
	    YYRHSLOC (Rhs, 0).last_column;				\
	}								\
    while (YYID (0))
#endif


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

#ifndef YY_LOCATION_PRINT
# if YYLTYPE_IS_TRIVIAL
#  define YY_LOCATION_PRINT(File, Loc)			\
     fprintf (File, "%d.%d-%d.%d",			\
	      (Loc).first_line, (Loc).first_column,	\
	      (Loc).last_line,  (Loc).last_column)
# else
#  define YY_LOCATION_PRINT(File, Loc) ((void) 0)
# endif
#endif


/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, state)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (YYID (0))

# define YY_SYMBOL_PRINT(Title, Type, Value, Location)			  \
do {									  \
  if (yydebug)								  \
    {									  \
      YYFPRINTF (stderr, "%s ", Title);					  \
      yy_symbol_print (stderr,						  \
		  Type, Value, Location, state); \
      YYFPRINTF (stderr, "\n");						  \
    }									  \
} while (YYID (0))


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_value_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, ot_state_t state)
#else
static void
yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, state)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    ot_state_t state;
#endif
{
  if (!yyvaluep)
    return;
  YYUSE (yylocationp);
  YYUSE (state);
# ifdef YYPRINT
  if (yytype < YYNTOKENS)
    YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# else
  YYUSE (yyoutput);
# endif
  switch (yytype)
    {
      default:
	break;
    }
}


/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_symbol_print (FILE *yyoutput, int yytype, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, ot_state_t state)
#else
static void
yy_symbol_print (yyoutput, yytype, yyvaluep, yylocationp, state)
    FILE *yyoutput;
    int yytype;
    YYSTYPE const * const yyvaluep;
    YYLTYPE const * const yylocationp;
    ot_state_t state;
#endif
{
  if (yytype < YYNTOKENS)
    YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  YY_LOCATION_PRINT (yyoutput, *yylocationp);
  YYFPRINTF (yyoutput, ": ");
  yy_symbol_value_print (yyoutput, yytype, yyvaluep, yylocationp, state);
  YYFPRINTF (yyoutput, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_stack_print (yytype_int16 *bottom, yytype_int16 *top)
#else
static void
yy_stack_print (bottom, top)
    yytype_int16 *bottom;
    yytype_int16 *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (YYID (0))


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yy_reduce_print (YYSTYPE *yyvsp, YYLTYPE *yylsp, int yyrule, ot_state_t state)
#else
static void
yy_reduce_print (yyvsp, yylsp, yyrule, state)
    YYSTYPE *yyvsp;
    YYLTYPE *yylsp;
    int yyrule;
    ot_state_t state;
#endif
{
  int yynrhs = yyr2[yyrule];
  int yyi;
  unsigned long int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %lu):\n",
	     yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      fprintf (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr, yyrhs[yyprhs[yyrule] + yyi],
		       &(yyvsp[(yyi + 1) - (yynrhs)])
		       , &(yylsp[(yyi + 1) - (yynrhs)])		       , state);
      fprintf (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (yyvsp, yylsp, Rule, state); \
} while (YYID (0))

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YY_SYMBOL_PRINT(Title, Type, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined __GLIBC__ && defined _STRING_H
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static YYSIZE_T
yystrlen (const char *yystr)
#else
static YYSIZE_T
yystrlen (yystr)
    const char *yystr;
#endif
{
  YYSIZE_T yylen;
  for (yylen = 0; yystr[yylen]; yylen++)
    continue;
  return yylen;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined __GLIBC__ && defined _STRING_H && defined _GNU_SOURCE
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static char *
yystpcpy (char *yydest, const char *yysrc)
#else
static char *
yystpcpy (yydest, yysrc)
    char *yydest;
    const char *yysrc;
#endif
{
  char *yyd = yydest;
  const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

# ifndef yytnamerr
/* Copy to YYRES the contents of YYSTR after stripping away unnecessary
   quotes and backslashes, so that it's suitable for yyerror.  The
   heuristic is that double-quoting is unnecessary unless the string
   contains an apostrophe, a comma, or backslash (other than
   backslash-backslash).  YYSTR is taken from yytname.  If YYRES is
   null, do not copy; instead, return the length of what the result
   would have been.  */
static YYSIZE_T
yytnamerr (char *yyres, const char *yystr)
{
  if (*yystr == '"')
    {
      YYSIZE_T yyn = 0;
      char const *yyp = yystr;

      for (;;)
	switch (*++yyp)
	  {
	  case '\'':
	  case ',':
	    goto do_not_strip_quotes;

	  case '\\':
	    if (*++yyp != '\\')
	      goto do_not_strip_quotes;
	    /* Fall through.  */
	  default:
	    if (yyres)
	      yyres[yyn] = *yyp;
	    yyn++;
	    break;

	  case '"':
	    if (yyres)
	      yyres[yyn] = '\0';
	    return yyn;
	  }
    do_not_strip_quotes: ;
    }

  if (! yyres)
    return yystrlen (yystr);

  return yystpcpy (yyres, yystr) - yyres;
}
# endif

/* Copy into YYRESULT an error message about the unexpected token
   YYCHAR while in state YYSTATE.  Return the number of bytes copied,
   including the terminating null byte.  If YYRESULT is null, do not
   copy anything; just return the number of bytes that would be
   copied.  As a special case, return 0 if an ordinary "syntax error"
   message will do.  Return YYSIZE_MAXIMUM if overflow occurs during
   size calculation.  */
static YYSIZE_T
yysyntax_error (char *yyresult, int yystate, int yychar)
{
  int yyn = yypact[yystate];

  if (! (YYPACT_NINF < yyn && yyn <= YYLAST))
    return 0;
  else
    {
      int yytype = YYTRANSLATE (yychar);
      YYSIZE_T yysize0 = yytnamerr (0, yytname[yytype]);
      YYSIZE_T yysize = yysize0;
      YYSIZE_T yysize1;
      int yysize_overflow = 0;
      enum { YYERROR_VERBOSE_ARGS_MAXIMUM = 5 };
      char const *yyarg[YYERROR_VERBOSE_ARGS_MAXIMUM];
      int yyx;

# if 0
      /* This is so xgettext sees the translatable formats that are
	 constructed on the fly.  */
      YY_("syntax error, unexpected %s");
      YY_("syntax error, unexpected %s, expecting %s");
      YY_("syntax error, unexpected %s, expecting %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s");
      YY_("syntax error, unexpected %s, expecting %s or %s or %s or %s");
# endif
      char *yyfmt;
      char const *yyf;
      static char const yyunexpected[] = "syntax error, unexpected %s";
      static char const yyexpecting[] = ", expecting %s";
      static char const yyor[] = " or %s";
      char yyformat[sizeof yyunexpected
		    + sizeof yyexpecting - 1
		    + ((YYERROR_VERBOSE_ARGS_MAXIMUM - 2)
		       * (sizeof yyor - 1))];
      char const *yyprefix = yyexpecting;

      /* Start YYX at -YYN if negative to avoid negative indexes in
	 YYCHECK.  */
      int yyxbegin = yyn < 0 ? -yyn : 0;

      /* Stay within bounds of both yycheck and yytname.  */
      int yychecklim = YYLAST - yyn + 1;
      int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
      int yycount = 1;

      yyarg[0] = yytname[yytype];
      yyfmt = yystpcpy (yyformat, yyunexpected);

      for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	  {
	    if (yycount == YYERROR_VERBOSE_ARGS_MAXIMUM)
	      {
		yycount = 1;
		yysize = yysize0;
		yyformat[sizeof yyunexpected - 1] = '\0';
		break;
	      }
	    yyarg[yycount++] = yytname[yyx];
	    yysize1 = yysize + yytnamerr (0, yytname[yyx]);
	    yysize_overflow |= (yysize1 < yysize);
	    yysize = yysize1;
	    yyfmt = yystpcpy (yyfmt, yyprefix);
	    yyprefix = yyor;
	  }

      yyf = YY_(yyformat);
      yysize1 = yysize + yystrlen (yyf);
      yysize_overflow |= (yysize1 < yysize);
      yysize = yysize1;

      if (yysize_overflow)
	return YYSIZE_MAXIMUM;

      if (yyresult)
	{
	  /* Avoid sprintf, as that infringes on the user's name space.
	     Don't have undefined behavior even if the translation
	     produced a string with the wrong number of "%s"s.  */
	  char *yyp = yyresult;
	  int yyi = 0;
	  while ((*yyp = *yyf) != '\0')
	    {
	      if (*yyp == '%' && yyf[1] == 's' && yyi < yycount)
		{
		  yyp += yytnamerr (yyp, yyarg[yyi++]);
		  yyf += 2;
		}
	      else
		{
		  yyp++;
		  yyf++;
		}
	    }
	}
      return yysize;
    }
}
#endif /* YYERROR_VERBOSE */


/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

/*ARGSUSED*/
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
static void
yydestruct (const char *yymsg, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, ot_state_t state)
#else
static void
yydestruct (yymsg, yytype, yyvaluep, yylocationp, state)
    const char *yymsg;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
    ot_state_t state;
#endif
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (state);

  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yytype, yyvaluep, yylocationp);

  switch (yytype)
    {

      default:
	break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
#if defined __STDC__ || defined __cplusplus
int yyparse (void *YYPARSE_PARAM);
#else
int yyparse ();
#endif
#else /* ! YYPARSE_PARAM */
#if defined __STDC__ || defined __cplusplus
int yyparse (ot_state_t state);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (void *YYPARSE_PARAM)
#else
int
yyparse (YYPARSE_PARAM)
    void *YYPARSE_PARAM;
#endif
#else /* ! YYPARSE_PARAM */
#if (defined __STDC__ || defined __C99__FUNC__ \
     || defined __cplusplus || defined _MSC_VER)
int
yyparse (ot_state_t state)
#else
int
yyparse (state)
    ot_state_t state;
#endif
#endif
{
  /* The look-ahead symbol.  */
int yychar;

/* The semantic value of the look-ahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the look-ahead symbol.  */
YYLTYPE yylloc;

  int yystate;
  int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Look-ahead token as an internal (translated) token number.  */
  int yytoken = 0;
#if YYERROR_VERBOSE
  /* Buffer for error messages, and its allocated size.  */
  char yymsgbuf[128];
  char *yymsg = yymsgbuf;
  YYSIZE_T yymsg_alloc = sizeof yymsgbuf;
#endif

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  yytype_int16 yyssa[YYINITDEPTH];
  yytype_int16 *yyss = yyssa;
  yytype_int16 *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[2];

#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
#if YYLTYPE_IS_TRIVIAL
  /* Initialize the default location before parsing starts.  */
  yylloc.first_line   = yylloc.last_line   = 1;
  yylloc.first_column = yylloc.last_column = 0;
#endif


  /* User initialization code.  */
#line 80 "cuex-otab.y"
{ cu_sref_cct_copy(&yylloc, &state->sref); }
/* Line 1069 of yacc.c.  */
#line 1328 "cuex/cuex-otab.c"
  yylsp[0] = yylloc;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack.  Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	yytype_int16 *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow (YY_("memory exhausted"),
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyexhaustedlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	yytype_int16 *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyexhaustedlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

  /* Do appropriate processing given the current state.  Read a
     look-ahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to look-ahead token.  */
  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a look-ahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid look-ahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the look-ahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);

  /* Discard the shifted token unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  yystate = yyn;
  *++yyvsp = yylval;
  *++yylsp = yylloc;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location.  */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 116 "cuex-otab.y"
    { if (!state->is_extern) state->otab->name = (yyvsp[(2) - (2)].str); }
    break;

  case 6:
#line 125 "cuex-otab.y"
    { ot_state_import(state, &(yyloc), (yyvsp[(2) - (2)].str)); }
    break;

  case 9:
#line 135 "cuex-otab.y"
    { state->current_range = ot_state_defrange(state, (yyvsp[(2) - (7)].idr), &(yyloc), (yyvsp[(4) - (7)].idr), (yyvsp[(6) - (7)].intrange)); }
    break;

  case 10:
#line 137 "cuex-otab.y"
    { state->current_range = NULL; }
    break;

  case 11:
#line 139 "cuex-otab.y"
    { ot_state_reserve(state, &(yyloc), (yyvsp[(2) - (5)].idr), (yyvsp[(4) - (5)].intrange)); }
    break;

  case 12:
#line 141 "cuex-otab.y"
    { ot_state_defopr(state, (yyvsp[(2) - (4)].idr), &(yyloc), (yyvsp[(1) - (4)].opr).r, (yyvsp[(1) - (4)].opr).has_ctor, (yyvsp[(4) - (4)].idr)); }
    break;

  case 13:
#line 143 "cuex-otab.y"
    { ot_state_defoption(state, &(yyloc), (yyvsp[(2) - (4)].idr), (yyvsp[(4) - (4)].str)); }
    break;

  case 15:
#line 149 "cuex-otab.y"
    { ot_state_defprop(state, (yyvsp[(3) - (7)].idr), &(yyloc), (yyvsp[(5) - (7)].i), (yyvsp[(7) - (7)].str), cu_false); }
    break;

  case 16:
#line 151 "cuex-otab.y"
    { ot_state_defprop(state, (yyvsp[(4) - (8)].idr), &(yyloc), (yyvsp[(6) - (8)].i), (yyvsp[(8) - (8)].str), cu_true); }
    break;

  case 18:
#line 154 "cuex-otab.y"
    { (yyval.str) = NULL; }
    break;

  case 20:
#line 158 "cuex-otab.y"
    { (yyval.i) = (yyvsp[(1) - (3)].i) + (yyvsp[(3) - (3)].i); }
    break;

  case 21:
#line 159 "cuex-otab.y"
    { (yyval.i) = (yyvsp[(1) - (3)].i) - (yyvsp[(3) - (3)].i); }
    break;

  case 22:
#line 160 "cuex-otab.y"
    { (yyval.i) = -(yyvsp[(2) - (2)].i); }
    break;

  case 24:
#line 165 "cuex-otab.y"
    { (yyval.i) = (yyvsp[(1) - (3)].i) * (yyvsp[(3) - (3)].i); }
    break;

  case 25:
#line 166 "cuex-otab.y"
    { (yyval.i) = (yyvsp[(1) - (3)].i) / (yyvsp[(3) - (3)].i); }
    break;

  case 26:
#line 171 "cuex-otab.y"
    {
	(yyval.intrange) = cu_gnew(struct ot_intrange);
	(yyval.intrange)->min = (yyvsp[(1) - (3)].i);
	(yyval.intrange)->maxp1 = (yyvsp[(3) - (3)].i) + 1;
    }
    break;

  case 27:
#line 177 "cuex-otab.y"
    {
	(yyval.intrange) = cu_gnew(struct ot_intrange);
	(yyval.intrange)->min = (yyvsp[(1) - (3)].i);
	(yyval.intrange)->maxp1 = (yyvsp[(3) - (3)].i);
    }
    break;

  case 28:
#line 183 "cuex-otab.y"
    {
	(yyval.intrange) = cu_gnew(struct ot_intrange);
	(yyval.intrange)->min = (yyvsp[(1) - (3)].i) + 1;
	(yyval.intrange)->maxp1 = (yyvsp[(3) - (3)].i);
    }
    break;


/* Line 1267 of yacc.c.  */
#line 1616 "cuex/cuex-otab.c"
      default: break;
    }
  YY_SYMBOL_PRINT ("-> $$ =", yyr1[yyn], &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if ! YYERROR_VERBOSE
      yyerror (&yylloc, state, YY_("syntax error"));
#else
      {
	YYSIZE_T yysize = yysyntax_error (0, yystate, yychar);
	if (yymsg_alloc < yysize && yymsg_alloc < YYSTACK_ALLOC_MAXIMUM)
	  {
	    YYSIZE_T yyalloc = 2 * yysize;
	    if (! (yysize <= yyalloc && yyalloc <= YYSTACK_ALLOC_MAXIMUM))
	      yyalloc = YYSTACK_ALLOC_MAXIMUM;
	    if (yymsg != yymsgbuf)
	      YYSTACK_FREE (yymsg);
	    yymsg = (char *) YYSTACK_ALLOC (yyalloc);
	    if (yymsg)
	      yymsg_alloc = yyalloc;
	    else
	      {
		yymsg = yymsgbuf;
		yymsg_alloc = sizeof yymsgbuf;
	      }
	  }

	if (0 < yysize && yysize <= yymsg_alloc)
	  {
	    (void) yysyntax_error (yymsg, yystate, yychar);
	    yyerror (&yylloc, state, yymsg);
	  }
	else
	  {
	    yyerror (&yylloc, state, YY_("syntax error"));
	    if (yysize != 0)
	      goto yyexhaustedlab;
	  }
      }
#endif
    }

  yyerror_range[0] = yylloc;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse look-ahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
	{
	  /* Return failure if at end of input.  */
	  if (yychar == YYEOF)
	    YYABORT;
	}
      else
	{
	  yydestruct ("Error: discarding",
		      yytoken, &yylval, &yylloc, state);
	  yychar = YYEMPTY;
	}
    }

  /* Else will try to reuse look-ahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

  /* Pacify compilers like GCC when the user code never invokes
     YYERROR and the label yyerrorlab therefore never appears in user
     code.  */
  if (/*CONSTCOND*/ 0)
     goto yyerrorlab;

  yyerror_range[0] = yylsp[1-yylen];
  /* Do not reclaim the symbols of the rule which action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      yyerror_range[0] = *yylsp;
      yydestruct ("Error: popping",
		  yystos[yystate], yyvsp, yylsp, state);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  *++yyvsp = yylval;

  yyerror_range[1] = yylloc;
  /* Using YYLLOC is tempting, but would change the location of
     the look-ahead.  YYLOC is available though.  */
  YYLLOC_DEFAULT (yyloc, (yyerror_range - 1), 2);
  *++yylsp = yyloc;

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", yystos[yyn], yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, state, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
  if (yychar != YYEOF && yychar != YYEMPTY)
     yydestruct ("Cleanup: discarding lookahead",
		 yytoken, &yylval, &yylloc, state);
  /* Do not reclaim the symbols of the rule which action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
		  yystos[*yyssp], yyvsp, yylsp, state);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
#if YYERROR_VERBOSE
  if (yymsg != yymsgbuf)
    YYSTACK_FREE (yymsg);
#endif
  /* Make sure YYID is used.  */
  return YYID (yyresult);
}


#line 189 "cuex-otab.y"


cuex_otab_range_t
ot_state_defrange(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		  cu_idr_t super_idr, ot_intrange_t intrange)
{
    cuex_otab_def_t super;

    cu_debug_assert(!state->current_range);
    super = cuex_otab_lookup(state->otab, super_idr);
    if (!super) {
	++state->error_cnt;
	cu_errf_at(sref, "Undefined range %s.", cu_idr_to_cstr(super_idr));
	return NULL;
    }
    else if (cuex_otab_def_kind(super) != cuex_otab_range_kind) {
	++state->error_cnt;
	cu_errf_at(sref, "%s is not a range.", cu_idr_to_cstr(super_idr));
	return NULL;
    }
    else
	return cuex_otab_defrange(state->otab, idr, cu_sref_new_copy(sref),
				  cuex_otab_range_from_def(super),
				  intrange->min, intrange->maxp1);
}

void
ot_state_defopr(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		int r, cu_bool_t has_ctor, cu_idr_t super_idr)
{
    cuex_otab_def_t super;

    if (state->is_extern)
	return;

    cu_debug_assert(!state->current_range);
    super = cuex_otab_lookup(state->otab, super_idr);
    if (!super) {
	++state->error_cnt;
	cu_errf_at(sref, "Undefined range %s.", cu_idr_to_cstr(super_idr));
    }
    else if (cuex_otab_def_kind(super) != cuex_otab_range_kind) {
	++state->error_cnt;
	cu_errf_at(sref, "%s is not a range.", cu_idr_to_cstr(super_idr));
    }
    else {
	cuex_otab_opr_t opr;
	opr = cuex_otab_defopr(state->otab, idr, cu_sref_new_copy(sref),
			       cuex_otab_range_from_def(super), r);
	if (has_ctor)
	    cuex_otab_opr_give_ctor(opr);
    }
}

void
ot_state_defprop(ot_state_t state, cu_idr_t idr, cu_sref_t sref,
		 unsigned int width, cu_str_t type_str, cu_bool_t is_implicit)
{
    cuex_otab_range_t range = state->current_range;
    if (!range)
	return;
    cuex_otab_defprop(state->otab, idr, cu_sref_new_copy(sref), range, width,
		      type_str? cu_str_to_cstr(type_str) : "unsigned int",
		      is_implicit);
}

void
ot_state_reserve(ot_state_t state, cu_sref_t sref, cu_idr_t super_idr,
		 ot_intrange_t intrange)
{
    cuex_otab_def_t super;

    cu_debug_assert(!state->current_range);
    super = cuex_otab_lookup(state->otab, super_idr);
    if (!super) {
	++state->error_cnt;
	cu_errf_at(sref, "Undefined range %s.", cu_idr_to_cstr(super_idr));
    }
    else if (cuex_otab_def_kind(super) != cuex_otab_range_kind) {
	++state->error_cnt;
	cu_errf_at(sref, "%s is not a range.", cu_idr_to_cstr(super_idr));
    }
    else
	cuex_otab_reserve(state->otab, cu_sref_new_copy(sref),
			  cuex_otab_range_from_def(super),
			  intrange->min, intrange->maxp1, state->is_extern);
}

static void
yyerror(cu_sref_t loc, ot_state_t state, char const *msg)
{
    ++state->error_cnt;
    cu_errf_at(loc, "%s", msg);
}

static struct cucon_pmap ot_keyword_map;

static int
yylex(ot_value_t val_out, cu_sref_t loc_out, ot_state_t state)
{
    int token = ERROR;
    FILE *in = state->in;
    char ch;
    cu_sref_t sref = &state->sref;

    ch = fgetc(in);
    for (;;) {
	while (isspace(ch)) {
	    cu_sref_advance_char(sref, ch);
	    ch = fgetc(in);
	}
	if (ch != '#')
	    break;
	do ch = fgetc(in); while (ch != '\n' && ch != EOF);
    }
    cu_sref_cct_copy(loc_out, sref);

    if (isalpha(ch) || ch == '_') {
	cu_str_t str = cu_str_new();
	do {
	    cu_str_append_char(str, ch);
	    cu_sref_advance_char(sref, ch);
	    ch = fgetc(in);
	} while (isalnum(ch) || ch == '_');
	if (cu_str_cmp_charr(str, "o", 1) == 0 && ch == '/') {
	    int len;
	    if (fscanf(in, "%d%n", &val_out->opr.r, &len) > 0) {
		cu_sref_advance_columns(sref, len);
		token = OPERATOR;
		ch = fgetc(in);
		if (ch == 'c')
		    val_out->opr.has_ctor = cu_true;
		else {
		    val_out->opr.has_ctor = cu_false;
		    ungetc(ch, in);
		    if (!isspace(ch)) {
			++state->error_cnt;
			cu_errf_at(sref, "Invalid operator flag.");
			token = ERROR;
		    }
		}
	    } else {
		ch = fgetc(in);
		if (ch == 'r') {
		    val_out->opr.has_ctor = cu_false;
		    val_out->opr.r = -1;
		    token = OPERATOR;
		} else {
		    ungetc(ch, in);
		    token = ERROR;
		}
	    }
	}
	else {
	    int *p;
	    ungetc(ch, in);
	    val_out->idr = cu_str_to_idr(str);
	    p = cucon_pmap_find_mem(&ot_keyword_map, val_out->idr);
	    token = p? *p : IDR;
	}
    }
    else if (isdigit(ch)) {
	int len;
	ungetc(ch, in);
	if (fscanf(in, "%i%n", &val_out->i, &len) == 1) {
	    cu_sref_advance_columns(sref, len);
	    token = INT;
	}
	else
	    token = ERROR;
    }
    else switch (ch) {
	case '"': {
	    cu_str_t str = cu_str_new();
	    token = STRING;
	    cu_sref_next(sref);
	    for (;;) {
		char ch_out;
		cu_sref_advance_char(sref, ch);
		ch = ch_out = fgetc(in);
		if (ch == EOF) {
		    ++state->error_cnt;
		    cu_errf_at(loc_out, "End of file while parsing string.");
		    token = ERROR;
		    break;
		}
		else if (ch == '"') {
		    do {
			cu_sref_advance_char(sref, ch);
			ch = fgetc(in);
		    } while (isspace(ch));
		    if (ch != '"') {
			ungetc(ch, in);
			break;
		    }
		    continue;
		}
		else if (ch == '\\') {
		    cu_sref_advance_char(sref, ch);
		    ch = ch_out = fgetc(in);
		    switch (ch) {
			case 'n': ch_out = '\n'; break;
			case 't': ch_out = '\t'; break;
			case '"': case '\\': break;
			default:
			    ++state->error_cnt;
			    cu_errf_at(sref, "Invalid character escape.");
			    break;
		    }
		}
		cu_str_append_char(str, ch_out);
	    }
	    cu_sref_next(sref);
	    val_out->str = str;
	    break;
	}
	case ':': case '=':
	case '[': case ']':
	case '(': case ')':
	case '+': case '-': case '*': case '/':
	    cu_sref_next(sref);
	    token = ch;
	    break;
	case '.':
	    cu_sref_next(sref);
	    ch = fgetc(in);
	    cu_sref_advance_char(sref, ch);
	    switch (ch) {
		case '.':
		    token = CTO;
		    break;
		case '!':
		    token = LTO;
		    break;
		default:
		    break;
	    }
	    break;
	case '!':
	    cu_sref_next(sref);
	    ch = fgetc(in);
	    cu_sref_advance_char(sref, ch);
	    switch (ch) {
		case '.':
		    token = RTO;
		    break;
		default:
		    break;
	    }
	    break;
	case EOF:
	    token = 0;
	    break;
    }
    cu_sref_set_sref_last(loc_out, sref);
    if (token == ERROR && ch != EOF) {
	++state->error_cnt;
	cu_errf_at(sref, "Unexpected character %c.", ch);
    }
    return token;
}

void
ot_error_cb(cuex_otab_t tab, cu_sref_t sref, char const *msg, ...)
{
    va_list va;
    va_start(va, msg);
    cu_verrf_at(sref, msg, va);
    va_end(va);
}

int
ot_parse_file(cuex_otab_t tab, cu_str_t path, cucon_list_t import_paths)
{
    struct ot_state state;
    state.import_paths = import_paths;
    state.error_cnt = 0;
    state.otab = tab;
    state.in = fopen(cu_str_to_cstr(path), "r");
    state.is_extern = cuex_otab_is_extern(tab);
    if (!state.in) {
	cu_errf("Could not open %s: %s", cu_str_to_cstr(path),
		strerror(errno));
	return 1;
    }
    cu_sref_cct(&state.sref, path, 1, 0);
    state.current_range = NULL;
    yyparse(&state);
    return state.error_cnt;
}

void
ot_state_import(ot_state_t state, cu_sref_t sref, cu_str_t rel_path)
{
    cu_str_t path;
    cucon_listnode_t incl_node;
    cu_bool_t is_extern;
    if (cu_str_size(rel_path) == 0) {
	++state->error_cnt;
	cu_errf_at(sref, "Zero path in include.");
	return;
    }
    if (cu_str_at(rel_path, 0) == '/')
	path = rel_path;
    else {
	cu_bool_t found = cu_false;
	for (incl_node = cucon_list_begin(state->import_paths);
	     incl_node != cucon_list_end(state->import_paths);
	     incl_node = cucon_listnode_next(incl_node)) {
	    struct stat st;
	    cu_str_t incl_path = cucon_listnode_ptr(incl_node);
	    path = cu_str_new_copy(incl_path);
	    cu_str_append_char(path, '/');
	    cu_str_append_str(path, rel_path);
	    if (stat(cu_str_to_cstr(path), &st) != -1) {
		found = cu_true;
		break;
	    }
	}
	if (!found) {
	    ++state->error_cnt;
	    cu_errf_at(sref, "Could not find %s in include path.",
		       cu_str_to_cstr(rel_path));
	    return;
	}
    }
    is_extern = cuex_otab_is_extern(state->otab);
    cuex_otab_set_extern(state->otab, cu_true);
    state->error_cnt += ot_parse_file(state->otab, path,
				      state->import_paths);
    cuex_otab_set_extern(state->otab, is_extern);
}

static cu_idr_t idr_h_prologue;
static cu_idr_t idr_h_epilogue;
static cu_idr_t idr_c_prologue;
static cu_idr_t idr_c_epilogue;

void
ot_state_defoption(ot_state_t state, cu_sref_t sref,
		   cu_idr_t idr, cu_str_t str)
{
    if (idr == idr_h_prologue) {
	if (!state->is_extern)
	    cuex_otab_set_h_prologue(state->otab, str);
    }
    else if (idr == idr_h_epilogue) {
	if (!state->is_extern)
	    cuex_otab_set_h_epilogue(state->otab, str);
    }
    else if (idr == idr_c_prologue) {
	if (!state->is_extern)
	    cuex_otab_set_c_prologue(state->otab, str);
    }
    else if (idr == idr_c_epilogue) {
	if (!state->is_extern)
	    cuex_otab_set_c_epilogue(state->otab, str);
    }
    else {
	++state->error_cnt;
	cu_errf_at(sref, "Unknown option %s.", cu_idr_to_cstr(idr));
    }
}

void
ot_init()
{
    int *token_ptr;
    cucon_pmap_cct(&ot_keyword_map);
#define K(str, token)							\
	cucon_pmap_insert_mem(&ot_keyword_map, cu_idr_by_cstr(str),	\
			      sizeof(int), &token_ptr);			\
	*token_ptr = (token)
    K("attr", ATTR);
    K("bit", BITS);
    K("bits", BITS);
    K("option", OPTION);
    K("implicit", IMPLICIT);
    K("import", IMPORT);
    K("provide", PROVIDE);
    K("range", RANGE);
    K("reserve", RESERVE);
#undef K
    idr_h_prologue = cu_idr_by_cstr("h_prologue");
    idr_h_epilogue = cu_idr_by_cstr("h_epilogue");
    idr_c_prologue = cu_idr_by_cstr("c_prologue");
    idr_c_epilogue = cu_idr_by_cstr("c_epilogue");
}


/* Main
 * ==== */

struct main_opts
{
    char const *path;
    char const *out_base;
    cu_bool_t update;
    struct cucon_list import_paths;
};

error_t
main_parseopt(int key, char *arg, struct argp_state *state)
{
    struct main_opts *opts = state->input;
    switch (key) {
	case ARGP_KEY_ARG:
	    if (opts->path)
		return ARGP_ERR_UNKNOWN;
	    opts->path = arg;
	    break;
	case ARGP_KEY_END:
	    if (!opts->path)
		argp_error(state, "Missing input path.");
	    if (!opts->out_base)
		argp_error(state, "Option -o is required.");
	    break;
	case 'o':
	    opts->out_base = arg;
	    break;
	case 'u':
	    opts->update = 1;
	    break;
	case 'I':
	    cucon_list_append_ptr(&opts->import_paths, cu_str_new_cstr(arg));
	    break;
	default:
	    return ARGP_ERR_UNKNOWN;
    }
    return 0;
}

struct argp_option main_options[] = {
    {"output-prefix", 'o', "PREFIX", 0,
     "Prefix for output, \".h\" and \".c\" will be appended.", 0},
    {"update", 'u', NULL, 0, "Only overwrite outputs if they would change."},
    {NULL, 'I', "DIRECTORY", 0, "Add DIRECTORY as import seach path."},
    {NULL}
};

struct argp main_argp = {
    main_options, main_parseopt, "FILES...", "Process cuex otab files.",
    NULL, NULL, NULL
};

int
main(int argc, char **argv)
{
    cuex_otab_t otab;
    struct main_opts main_opts;
    int err_cnt;
    cucon_init();
    ot_init();
    cucon_list_init(&main_opts.import_paths);
    main_opts.out_base = NULL;
    main_opts.path = NULL;
    main_opts.update = 0;
    argp_parse(&main_argp, argc, argv, 0, NULL, &main_opts);
    cu_debug_assert(main_opts.out_base);
    otab = cuex_otab_new(16, ot_error_cb);
    err_cnt = ot_parse_file(otab, cu_str_new_cstr(main_opts.path),
			    &main_opts.import_paths);
    if (!err_cnt) {
	cu_str_t out_h, out_c;
	out_h = cu_str_new_2cstr(main_opts.out_base, ".h");
	out_c = cu_str_new_2cstr(main_opts.out_base, ".c");
	if (main_opts.update) {
	    cu_str_t out_h_old = NULL, out_c_old = NULL;
	    if (cuos_dentry_type(out_h) == cuos_dentry_type_file) {
		out_h_old = out_h;
		out_h = cu_str_new_2cstr(main_opts.out_base, ".h~");
	    }
	    if (cuos_dentry_type(out_c) == cuos_dentry_type_file) {
		out_c_old = out_c;
		out_c = cu_str_new_2cstr(main_opts.out_base, ".c~");
	    }
	    if (!cuex_otab_print_std_sources(otab, out_h, out_c))
		return 2;
	    if (out_h_old && cuos_file_update(out_h, out_h_old) < 0) {
		perror("cuos_file_update");
		++err_cnt;
	    }
	    if (out_c_old && cuos_file_update(out_c, out_c_old) < 0) {
		perror("cuos_file_update");
		++err_cnt;
	    }
	} else {
	    if (!cuex_otab_print_std_sources(otab, out_h, out_c))
		return 2;
	}
    }
    return err_cnt? 2 : 0;
}

