/* Part of the culibs project, <http://www.eideticdew.org/culibs/>.
 * Copyright (C) 2007  Petter Urkedal <urkedal@nbi.dk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CUEX_INTF_H
#define CUEX_INTF_H

#include <cuex/fwd.h>
#include <cuoo/intf.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cuex_intf_h cuex/intf.h: Interface Numbers
 *@{\ingroup cuex_mod
 * \see cuoo_intf_h
 * \see cuex_compound_h
 */

#define CUEX_INTF_COMPOUND	0x40
#define CUEX_INTF_COMPOUND_BOX(x) cu_box_ptr(cuex_intf_compound_t, x)

/*!@}*/
CU_END_DECLARATIONS

#endif
