/* Part of the culibs project, <http://www.eideticdew.org/culibs/>.
 * Copyright (C) 2005--2007  Petter Urkedal <urkedal@nbi.dk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CUEX_OPRINFO_H
#define CUEX_OPRINFO_H

#include <cuex/fwd.h>
#include <cucon/pmap.h>
#include <stdint.h>

CU_BEGIN_DECLARATIONS

struct cuex_oprinfo
{
    struct cucon_umap_node node;
    char const *name;
    size_t cache_size;
    void (*cache_ctor)(cuex_opn_t opn);
    uint_least32_t flags;
};

cuex_oprinfo_t cuex_oprinfo(cuex_meta_t opr);

CU_SINLINE cuex_meta_t cuex_oprinfo_opr(cuex_oprinfo_t oi)
{ return cucon_umap_node_key(&oi->node); }

CU_SINLINE char const *cuex_oprinfo_name(cuex_oprinfo_t oi)
{ return oi->name; }

CU_SINLINE size_t cuex_oprinfo_cache_size(cuex_oprinfo_t oi)
{ return oi->cache_size; }

CU_SINLINE void (*cuex_oprinfo_cache_ctor(cuex_oprinfo_t oi))(cuex_opn_t opn)
{ return oi->cache_ctor; }

/*!This is called from the <tt>.c</tt>-file generated by <tt>cuex_otcomp</tt>
 * to index them to make them available to \ref cuex_oprinfo.  Call the
 * generated initialisation function instead. */
void cuex_oprinfo_register(cuex_oprinfo_t arr);

cu_bool_t cuex_oprinfo_conj(cu_clop(cb, cu_bool_t, cuex_oprinfo_t));

CU_END_DECLARATIONS

#endif
