# -*- RPM-SPEC -*-
%define enable_doc 0
Summary: Containers and Convenience Interfaces for Garbage Collected C
Name: culibs
Version: 0.24
Release: 1
Source0: %{name}-%{version}.tar.bz2
License: GPL
Group: Development/Libraries
Requires: gc
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-buildroot
BuildRequires: gc-devel libatomic_ops-devel
%{?use_libffi:BuildRequires: libffi-devel}
%{?use_buddy:BuildRequires: buddy-devel}

%package devel
Summary: Garbage Collected C Libraries
Group: Development/Libraries
Requires: culibs = %{version}

%description
Common containers and some less common containes designed for garbage
collection.  It includes a string type; list types; several hash map
and set types, one with weak keys; a red-black tree type; a priority
queue type; graph types; a partial order map type; and more.  It also
includes architecture-independent binary IO and some convenient
interfaces to the system.  It uses the Boehm-Wieser-Demers conservative
collector.

%description devel
Common containers and some less common containes designed for garbage
collection.  It includes a string type; list types; several hash map
and set types, one with weak keys; a red-black tree type; a priority
queue type; graph types; a partial order map type; and more.  It also
includes architecture-independent binary IO and some convenient
interfaces to the system.  It uses the Boehm-Wieser-Demers conservative
collector.

%prep
%setup -q

%build
export PKG_CONFIG_PATH=/usr/lib/pkgconfig
%configure --%{?use_libffi:with:without}-libffi
make

%install
test "%{buildroot}" != / && rm -rf "%{buildroot}"
make install DESTDIR="%{buildroot}"
%if %{enable_doc}
make install-doc DESTDIR="%{buildroot}"
%endif

%clean
test "%{buildroot}" != / && rm -rf "%{buildroot}"

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%_libdir/libcu*-%{version}.so

%files devel
%defattr(-,root,root,-)
%_libdir/libcu*.la
%_libdir/libcu*[a-z].so
%_libdir/libcu*.a
%_libdir/pkgconfig/cu*.pc
%_includedir/culibs-%{version}
%_bindir/cuex-otab
%_bindir/cuset
%_bindir/sedi
%if %{enable_doc}
%doc %_docdir/%{name}-%{version}/html
%endif
