/*-*-C-*-
 * Copyright 2005  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_ALGO_H
#define CU_ALGO_H

#include <cu/fwd.h>

CU_BEGIN_DECLARATIONS

/*!Enumeration of partial order relations. */
typedef enum {
    cu_order_none,
    cu_order_lt = 1,
    cu_order_gt = 2,
    cu_order_eq = 3
} cu_order_t;

CU_SINLINE void
cu_ptr_swap(cu_ptr_ptr_t p0, cu_ptr_ptr_t p1)
{
    void *pS = *(void **)p0;
    *(void **)p0 = *(void **)p1;
    *(void **)p1 = pS;
}

CU_SINLINE void
cu_ptr_rotl(cu_ptr_ptr_t p0, cu_ptr_ptr_t p1, cu_ptr_ptr_t p2)
{
    void *pS = *(void **)p0;
    *(void **)p0 = *(void **)p1;
    *(void **)p1 = *(void **)p2;
    *(void **)p2 = pS;
}

CU_END_DECLARATIONS

#endif
