/*-*-C-*-
 * Copyright 2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_CLOS_H
#define CU_CLOS_H

#include <cu/fwd.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cu_clos_h cu/clos.h: Closures
 *@{\ingroup cu_mod */

/* Preprocessor Tools
 * ================== */

#define cuP_pp_unparen(argl) cuP_pp_unparen0 argl
#define cuP_pp_unparen0(args...) args
#define cuP_pp_argl_append(argl, arg) (cuP_pp_unparen(argl), arg)
#define cuP_pp_argl_prepend(argl, arg) (arg, cuP_pp_unparen(argl))
#define cuP_pp_argl0_append(argl, arg) (arg)
#define cuP_pp_argl0_prepend(argl, arg) (arg)
#define cuP_pp_apply(macro, args...) macro args


/* Implementation
 * ============== */

/* The definition of a variant must provide
 *
 *     cuP_clos_formal(clos_s, alops, argl)
 *	   Return the formal argument list, given
 *             'clos_s'	the struct name of the closure
 *             'alops'	the prefix to the argument list macros, either
 *			'cuP_pp_argl_' or 'cuP_pp_argl0_'.
 *             'argl'	the formal argument list.
 *
 *     cu_clptr(var)
 *     cu_clptr0(var)
 *     cu_clop_null
 *     cu_clop_is_null(clptr)
 *
 *     cu_call(clptr, args...)
 *     cu_call0(clptr)
 *
 *     cuP_clos_base(clos_s, result_t, alops, argl)
 *     cu_clos_cct(clos, PFX)
 *     cu_clos_ref(clos)
 *     cu_clos_from_clptr(clptr)
 *     cuP_clos_arg_dcln(clos_s, var)
 *
 *     cu_func_ref(name, proto)
 *     cu_func_decl_e(name, proto)
 *     cu_func_init_e(name, proto)
 *     cu_func_decl(name, proto)
 *     cu_func_init(name, proto)
 */
#include <cu/conf.h>
#define CU_CLOS_VARIANT_GENERIC	1
#define CU_CLOS_VARIANT_I386		2
#if CUCONF_CLOS_VARIANT == CU_CLOS_VARIANT_GENERIC
#  include <cu/generic/clos.h>
#elif CUCONF_CLOS_VARIANT == CU_CLOS_VARIANT_I386
#  include <cu/i386/clos.h>
#else
#  error Missing a valid definition of CUCONF_CLOS_VARIANT in config.h.
#endif

#define cu_clos_base(self_s, proto) cuP_clos_base(self_s, proto)
#define cu_clos_formal(self_s, args...)					\
    cuP_pp_unparen(cuP_clos_formal(self_s, cuP_pp_argl_, (args)))
#define cu_clos_formal0(self_s)						\
    cuP_pp_unparen(cuP_clos_formal(self_s, cuP_pp_argl0_, ()))


/* High-level interface
 * ==================== */

#define cuP_clos_common(PFX, linkage, result_t, alops, argl, cargs)	\
    struct PFX##_s {							\
	cuP_clos_base (PFX##_s, result_t, alops, argl);			\
	cuP_pp_unparen(cargs)						\
    };									\
    typedef struct PFX##_s PFX##_t;					\
    typedef cuP_clop(PFX##_clop_t, result_t, alops, argl);		\
									\
    linkage result_t PFX##_fn cuP_clos_formal(PFX##_s, alops, argl);	\
							    		\
    CU_SINLINE void PFX##_cct(PFX##_t *clos)				\
    {									\
	cuP_clos_cct(clos, PFX##_fn);					\
    }									\
									\
    CU_SINLINE PFX##_clop_t PFX##_prep(PFX##_t *clos)			\
    {									\
	cuP_clos_cct(clos, PFX##_fn);					\
	return (PFX##_clop_t)clos;					\
    }

/*!Forward declare and define closure struct for a closure with static
 * linkage. */
#define cu_clos_decl(PFX, proto, cargs) cuP_clos_decl(PFX, proto, cargs)
#define cuP_clos_decl(PFX, result_t, alops, argl, cargs)		\
    cuP_clos_common(PFX, static, result_t, alops, argl, cargs)

/*!Provide the function definition for a closure which was previously
 * declared with \ref cu_clos_decl. */
#define cu_clos_define(PFX, proto) cuP_clos_define(PFX, proto)
#define cuP_clos_define(PFX, result_t, alops, argl)			\
    result_t PFX##_fn cuP_clos_formal(PFX##_s, alops, argl)

/*!Forward declare and define closure struct for a closure with extern
 * linkage. */
#define cu_clos_decl_e(PFX, proto, cargs) cuP_clos_decl_e(PFX, proto, cargs)
#define cuP_clos_decl_e(PFX, result_t, alops, argl, cargs)		\
    cuP_clos_common(PFX, extern, result_t, alops, argl, cargs)

/*!Provide the function definition for a closure which was previously
 * declared with \ref cu_clos_decl_e. */
#define cu_clos_define_e(PFX, proto) cuP_clos_define_e(PFX, proto)
#define cuP_clos_define_e(PFX, result_t, alops, argl)			\
    result_t PFX##_fn cuP_clos_formal(PFX##_s, alops, argl)

/*!Define a closure (function and struct) with static linkage which has
 * no previous forward declaration. */
#define cu_clos_def(PFX, proto, cargs)					\
    cuP_clos_decl(PFX, proto, cargs)					\
    cuP_clos_define(PFX, proto)

#define cu_prot(res_t, argl...) res_t, cuP_pp_argl_, (argl)
#define cu_prot0(res_t) res_t, cuP_pp_argl0_, ()

#define cu_clop(cptr, result_t, argl...) \
    cuP_clop(cptr, result_t, cuP_pp_argl_, (argl))
#define cu_clop0(cptr, result_t) \
    cuP_clop(cptr, result_t, cuP_pp_argl0_, ())

#define cu_clos_self(PFX) cuP_clos_arg_dcln(PFX##_s, self)

/* A generic pointer. Must be cast before call. */
typedef cu_clop0(cu_clop_generic_t, void);


/* Deprecated */
#define cu_clos_cct(clos, PFX) cuP_clos_cct(clos, PFX##_fn)
#define cu_proto , cuP_pp_argl_,
#define cu_proto0 , cuP_pp_argl0_,

/*!@}*/
CU_END_DECLARATIONS

#endif
