#include <cu/clos.h>
#include <assert.h>

cu_clos_def(my_clos, int cu_proto(int k, double x),
    ( int i; int j; ))
{
    cu_clos_self(my_clos);
    assert(self->i == 1001);
    assert(self->j == 1002);
    assert(k == 1003);
    assert(x == 1.1);
    return 1004;
}

cu_clop_def(plain, int, int k, double x)
{
    assert(k == 1010);
    assert(x == 1.2);
    return 1011;
}

cu_clos_def(testfn0,
	    int cu_proto(int i, int j),
	    (int k; int l;))
{
    cu_clos_self(testfn0);
    return i*self->k + j*self->l;
}

cu_clos_decl(testfn1,
	     int cu_proto(char *s),
	     (int n;));

cu_clos_define(testfn1, int cu_proto(char *s))
{
    cu_clos_self(testfn1);
    return atoi(s) + self->n;
}


int
main()
{
    int l;
    my_clos_t clos;
    testfn0_t fn0;
    testfn1_t fn1;

    clos.i = 1001;
    clos.j = 1002;
    l = cu_call(my_clos_prep(&clos), 1003, 1.1);
    assert(l == 1004);

    l = cu_call(plain, 1010, 1.2);
    assert(l == 1011);

    testfn0_cct(&fn0);
    fn0.k = 10;
    fn0.l = 100;
    assert(cu_call(testfn0_prep(&fn0), 2, 3) == 320);

    testfn1_cct(&fn1);
    fn1.n = 6;
    assert(cu_call(testfn1_prep(&fn1), "4") == 10);

    return 0;
}
