#include <cu/fwd.h>
#include <cu/memory.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>

int
main()
{
    size_t n_repeat = 1000;
    char const* s;
    size_t i;

    cu_init();

    s = cu_struniq("gjenganger");
    assert(s == cu_struniq("gjenganger"));
    assert(s != cu_struniq("gjest"));
    GC_gcollect();

    for (i = 0; i < n_repeat; ++i) {
	static char str[sizeof(int)*3 + 1];
	sprintf(str, "%ld", lrand48() % n_repeat);
	/*&char const* str_u =*/ cu_struniq(str);
	if (i % (n_repeat/4) == 0)
	    GC_gcollect();
    }
    
    return 0;
}
