/*-*-C-*-
 * Copyright 2002--2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CU_DEBUG_H
#define CU_DEBUG_H

#include <cu/fwd.h>
#include <cu/conf.h>
#include <cu/inherit.h>
#include <stdio.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cu_debug cu/debug.h: Utilities for Debugging
 * @{ \ingroup cu_mod */

/*
 *  Debugging Selection
 */
typedef enum {
    cu_debug_flag_info		= 1 << 0,
    cu_debug_show_alloc_flag	= 1 << 1,
    cu_debug_soft_exit_flag	= 1 << 2,
    cu_debug_show_collect_flag	= 1 << 3,
    cu_debug_expensive_typing	= 1 << 4
} cu_debug_flags_t;

cu_debug_flags_t cu_debug_enable(cu_debug_flags_t);
cu_debug_flags_t cu_debug_disable(cu_debug_flags_t);
cu_debug_flags_t cu_debug_select(cu_debug_flags_t);
void cu_debug_enable_backtrace_on_signal(void);

/*
 *  Debug Messages
 */
void cuP_debug_msg(const char *, int, const char *, cu_debug_flags_t,
		    const char *, ...);
extern void (*cuP_debug_bug_report)(const char *, int, const char *, ...);

void		cu_findent(FILE *fp, int i);
void		cu_debug_abort(void) CU_ATTR_NORETURN;
//#define		cu_debug_abort() abort()
void		cu_debug_trap(void);

#ifndef CU_NDEBUG

extern cu_bool_fast_t cuP_debug_is_enabled;

cu_bool_fast_t	cu_debug_is_enabled(cu_debug_flags_t);
#define		cu_debug_inform(args...) \
    cuP_debug_msg(__FILE__, __LINE__, "debug", cu_debug_flag_info, args)
#define		cu_debug_warning(args...) \
    cuP_debug_msg(__FILE__, __LINE__, "warning", 0, args)
#define		cu_debug_error(args...) \
    (cuP_debug_msg(__FILE__, __LINE__, "error", 0, args), cu_debug_abort())
#define		cu_debug_assert(test) \
    ((test)? (void)0 : (void)cu_debug_error("assertion '%s' failed", #test))
void		cu_debug_indent();
void		cu_debug_unindent();
#define		cu_debug_here() cu_debug_inform("here")

#else

#define		cu_debug_is_enabled()		cu_false
#define		cu_debug_inform(args...)		((void)0)
#define		cu_debug_warning(args...)	((void)0)
#define		cu_debug_error(args...) \
    (cuP_debug_bug_report(__FILE__, __LINE__, args), cu_debug_abort())
#define		cu_debug_assert(test)		((void)0)
#define		cu_debug_indent()		((void)0)
#define		cu_debug_unindent()		((void)0)
#define		cu_debug_here()		((void)0)
#define		cu_debug_declare_cls(ptr, cls)	((void)0)
#define		cu_debug_assert_cls(ptr, cls)	((void)0)
#define		cu_debug_assert_is_ex(ptr)	((void)0)
#define		cu_debug_assert_is_ex_kind(ptr, code) ((void)0)

#endif

#define		cu_debug_unreachable() \
	cu_debug_error("This point should not have been reached.")
#define		cu_unreachable() cu_debug_unreachable()

#ifndef CU_NDEBUG
void cuP_dprintf(char const *, int, char const *, char const *, ...);
#define cu_dprintf(args...) cuP_dprintf(__FILE__, __LINE__, args)
cu_bool_t cu_debug_key(char const *key);
#else
#define cu_dprintf(args...) ((void)0)
#define cu_debug_key(key) cu_false
#endif


/* Client Debug
 * ============ */

void cu_err_invalid_arg(char const *function, int argnum, char const *argname,
			char const *msg);
#ifdef CUCONF_DEBUG_CLIENT
#define cu_check_arg(argnum, argname, test)				\
    ((test)? ((void)0)							\
	   : cu_err_invalid_arg(__FUNCTION__, argnum, #argname,		\
				"must fulfil "#test))
#else
#define cu_check_arg(argnum, argname, test) ((void)0)
#endif

/*!@}*/
CU_END_DECLARATIONS

#endif
