/*-*-C-*-
 * Copyright 2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_DIAG_H
#define CU_DIAG_H

#include <cu/fwd.h>
#include <cu/clos.h>
#include <stdio.h>
#include <stdarg.h>
#include <cu/va_ref.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cu_diag cu/diag.h: Printing and Error Reporting
 * @{ \ingroup cu_mod */

typedef cu_clop(cu_diag_format_fn_t, void, cu_str_t fmt, cu_va_ref_t va,
					   FILE *out);

void cu_diag_define_format_key(char key, cu_diag_format_fn_t fn);
void cu_vfprintf(FILE *, char const *, va_list va);
void cu_fprintf(FILE *, char const *, ...);

extern int cuP_verbosity;
CU_SINLINE int cu_verbosity() { return cuP_verbosity; }
void cu_set_verbosity(int verbosity);

void cu_raise_out_of_memory(size_t size);

CU_SINLINE void
cu_check_out_of_memory(void *ptr, size_t size)
{
    if (!ptr)
	cu_raise_out_of_memory(size);
}

/*!@}*/
CU_END_DECLARATIONS

#endif
