/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_HCOBJ_H
#define CU_HCOBJ_H

#include <cu/fwd.h>
#include <cu/conf.h>
#include <atomic_ops.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cu_hcobj_h cu/hcobj.h:
 *@{\ingroup cu_mod */

typedef struct cu_hcobj_s *cu_hcobj_t;

#ifdef CUCONF_ENABLE_RECLAIM_NOTIFICATION

#if CUCONF_SIZEOF_LONG > 4
#  define CU_HC_GENERATION 0
#else
#  define CU_HC_GENERATION 0
#endif
#define CU_HCOBJ_NEEDED 1
#define CU_HCOBJ CU_OBJ cu_inherit (cu_hcobj_s);
#define CU_HCOBJ_SHIFT sizeof(struct cu_hcobj_s)
#define CU_HCOBJ_INIT CU_OBJ_INIT { 0 },
struct cu_hcobj_s
{
    AO_t hcset_next;
#if CU_HC_GENERATION
    AO_t generation;
#endif
};

#else /* !CUCONF_ENABLE_RECLAIM_NOTIFICATION */

#define CU_HCOBJ
#define CU_HCOBJ_SHIFT 0
#define CU_HCOBJ_INIT

#endif /* !CUCONF_ENABLE_RECLAIM_NOTIFICATION */

/*!@}*/
CU_END_DECLARATIONS

#endif
