#include <cu/dyn.h>

#define N_ALLOC 0x2000000

typedef struct test_s *test_t;
struct test_s
{
    CU_HCOBJ
    int arg0;
    int arg1;
};

cudyn_stdtype_t _test_type;
CU_SINLINE cudyn_type_t test_type()
{ return cudyn_stdtype_to_type(_test_type); }

void
test_GC_malloc(int n_alloc)
{
    int i;
    for (i = 0; i < n_alloc; ++i) {
	test_t o = GC_malloc(sizeof(struct test_s));
	o->arg0 = i;
	o->arg1 = i;
    }
}

void
test_onew(int n_alloc)
{
    int i;
    for (i = 0; i < n_alloc; ++i) {
	test_t o = cudyn_onew(test);
	o->arg0 = i;
	o->arg1 = i;
    }
}

void
test_hnew_noneq(int n_alloc)
{
    int i;
    for (i = 0; i < n_alloc; ++i) {
	struct test_s o;
	o.arg0 = i;
	o.arg1 = i;
	cudyn_hnew(test, &o);
    }
}

void
test_hnew_eq(int n_alloc)
{
    int i;
    for (i = 0; i < n_alloc; ++i) {
	struct test_s o;
	o.arg0 = 0;
	o.arg1 = 0;
	cudyn_hnew(test, &o);
    }
}

void
test_malloc_free(int n_alloc)
{
    int i;
    for (i = 0; i < n_alloc; ++i) {
	test_t o = malloc(sizeof(struct test_s));
	o->arg0 = i;
	o->arg1 = i;
	free(o);
    }
}

int
main(int argc, char **argv)
{
    char const *alloc_name;
    int n_alloc = N_ALLOC;
    time_t t;
    int alloc_type;
    if (argc < 2 || sscanf(argv[1], "%d", &alloc_type) != 1) {
	fprintf(stderr, "%s ALLOC_TYPE\n", argv[0]);
	exit(2);
    }
    cu_init();
    _test_type = cudyn_stdtype_new_hcs(sizeof(struct test_s) - CU_HCOBJ_SHIFT);
    t = -clock();
    switch (alloc_type) {
	case 0:
	    test_GC_malloc(n_alloc);
	    alloc_name = "GC_malloc";
	    break;
	case 1:
	    test_onew(n_alloc);
	    alloc_name = "cu_onew";
	    break;
	case 2:
	    n_alloc /= 4;
	    test_hnew_noneq(n_alloc);
	    alloc_name = "cu_hnew (different objects)";
	    break;
	case 3:
	    test_hnew_eq(n_alloc);
	    alloc_name = "cu_hnew (same object)";
	    break;
	case 4:
	    test_malloc_free(n_alloc);
	    alloc_name = "malloc, free";
	    break;
    }
    GC_gcollect();
    t += clock();
    printf("%s: %lg s per alloc\n", alloc_name,
	   t/((double)CLOCKS_PER_SEC * n_alloc));
    return 0;
}
