/*-*-C-*-
 * Copyright 2005  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_IDR_H
#define CU_IDR_H

#include <cu/dyn.h>

CU_BEGIN_DECLARATIONS
/*!\defgroup cu_idr cu/idr.h: Identifiers (Strings with Pointer Equality)
 * @{ \ingroup cu_mod */

struct cu_idr_s
{
    CU_HCOBJ
    size_t key_size;
};

extern cudyn_stdtype_t cuP_idr_type;

/*!Returns the type descriptor of all \c cu_idr_t objects. */
CU_SINLINE cudyn_type_t cu_idr_type()
{ return cudyn_stdtype_to_type(cuP_idr_type); }

/*!True iff the dynamically typed object at \a dyn is an \c cu_idr_t. */
CU_SINLINE cu_bool_t cu_is_idr(void *dyn)
{ return cuex_meta(dyn) == cudyn_type_to_meta(cu_idr_type()); }

/*!Returns the identifier with the name \a cstr.  The result is hashconsed,
 * meaning that two simultaneously live \c cu_idr_t objects constructed
 * from the same string (according to strcmp) have identical pointers. */
cu_idr_t cu_idr_by_cstr(char const *cstr);

/*!Returns the identifier with the name given by \a arr to \a arr +
 * \a size.  See \ref cu_idr_by_cstr. */
cu_idr_t cu_idr_by_charr(char const *arr, size_t size);

/*!Return a C string strcmp-equal to the one passed upon costruction. */
CU_SINLINE char const *cu_idr_to_cstr(cu_idr_t idr)
{ return (char const *)(idr + 1); }

/*!A simple pointer comparison. */
CU_SINLINE cu_bool_t cu_idr_eq(cu_idr_t idr0, cu_idr_t idr1)
{ return idr0 == idr1; }

/*!Returns <tt>strcmp(cu_idr_to_cstr(\a idr0), cu_idr_to_cstr(\a idr1))</tt>.*/
int cu_idr_strcmp(cu_idr_t idr0, cu_idr_t idr1);

#define cu_idr_of_cstrq cu_idr_of_cstr
#define cu_idr_to_cstrq cu_idr_to_cstr

#ifndef CU_IN_DOXYGEN
extern cu_clop(cu_idr_strcmp_clop, int, cu_idr_t, cu_idr_t);
#endif

/*!@}*/
CU_END_DECLARATIONS

#endif
