#include <cu/conf.h>
#include <cu/int.h>
#include <assert.h>

int
ubit(unsigned long n)
{
    int i;
    for (i = sizeof(unsigned long)*8 - 1; i >= 0; --i)
	if (n & (1L << i))
	    return i;
    return -1;
}

int
lbit(unsigned long n)
{
    size_t i;
    for (i = 0; i < sizeof(unsigned long)*8;  ++i)
	if (n & (1 << i))
	    return i;
    return -1;
}

int
main()
{
    unsigned long i;
    for (i = 1; i < 1000000; ++i) {
	unsigned long j = lrand48();
	if (j == 0)
	    continue;
	assert(ubit(j) == cu_ulong_floor_log2(j));
	assert(lbit(j) == cu_ulong_log2_lowbit(j));
    }
    return 0;
}
