/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cu/scratch.h>
#include <cu/memory.h>

void
cuP_scratch_resize_min(cu_scratch_t scr, size_t size)
{
    scr->ptr = cu_galloc(size);
    scr->size = size;
}

void
cuP_scratch_resize_log(cu_scratch_t scr, size_t size)
{
    if (scr->size*2 > size)
	size = scr->size*2;
    scr->ptr = cu_galloc(size);
    scr->size = size;
}
