/*-*-C-*-
 * Copyright 2002--2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cu/sref.h>
#include <cu/memory.h>
#include <cu/str.h>


void
cu_sref_cct(cu_sref_t srf, cu_str_t path, int line, int column)
{
    srf->chain_tail = NULL;
    srf->path = path;
    srf->line = line;
    srf->column = column;
    srf->tabstop = 8;
}

cu_sref_t
cu_sref_new(cu_str_t path, int line, int column)
{
    cu_sref_t srf = cu_gnew(struct cu_sref_s);
    srf->chain_tail = NULL;
    srf->path = path;
    srf->line = line;
    srf->column = column;
    srf->tabstop = 8;
    return srf;
}

cu_sref_t
cu_sref_new_cstr(char const *path, int line, int column)
{
    return cu_sref_new(cu_str_new_cstr(path), line, column);
}

void
cu_sref_set_tabstop(cu_sref_t srf, int w)
{
    srf->tabstop = w;
}

void
cu_sref_cct_copy(cu_sref_t srf, cu_sref_t srf0)
{
    srf->chain_tail = srf0->chain_tail;
    srf->path = srf0->path;
    srf->line = srf0->line;
    srf->column = srf0->column;
    srf->tabstop = srf0->tabstop;
}

cu_sref_t
cu_sref_new_copy(cu_sref_t srf0)
{
    cu_sref_t srf = cu_gnew(struct cu_sref_s);
    srf->chain_tail = srf0->chain_tail;
    srf->path = srf0->path;
    srf->line = srf0->line;
    srf->column = srf0->column;
    srf->tabstop = srf0->tabstop;
    return srf;
}

void
cu_sref_newline(cu_sref_t srf)
{
    if (srf->column > 0)
	srf->column = 0;
    ++srf->line;
}

void
cu_sref_tab(cu_sref_t srf)
{
    srf->column = (srf->column/srf->tabstop + 1)*srf->tabstop;
}

void
cu_sref_fprint(cu_sref_t srf, FILE* file)
{
    if (!cu_sref_is_known(srf)) {
	fprintf(file, "#[unknown]");
	return;
    }
    fwrite(cu_str_charr(srf->path), 1, cu_str_size(srf->path), file);
    if (srf->column >= 0)
	/* Note. 'vi' starts counting at column 1. 'emacs' starts at 0
	 * but assumes error messages starts at 1. */
	fprintf(file, ":%d:%d",
		cu_sref_line(srf), cu_sref_column(srf) + 1);
    else
	fprintf(file, ":%d", cu_sref_line(srf));
}
