/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cu/test.h>
#include <stdio.h>
#include <stdlib.h>

static AO_t cuP_test_fail_count = 0;
static cu_test_bugaction_t cuP_test_bugaction = cu_test_bugaction_abort;

void
cu_test_on_bug(cu_test_bugaction_t action)
{
    cuP_test_bugaction = action;
}

int
cu_test_bug_count()
{
    return AO_load_acquire_read(&cuP_test_fail_count);
}

void
cuP_test_vbugf(char const *file, int line, char const *msg, va_list va)
{
    AO_fetch_and_add1(&cuP_test_fail_count);
    fprintf(stderr, "%s:%d: ", file, line);
    vfprintf(stderr, msg, va);
    fputc('\n', stderr);
    switch (cuP_test_bugaction) {
	case cu_test_bugaction_cont:
	    return;
	case cu_test_bugaction_abort:
	    abort();
	case cu_test_bugaction_exit:
	    exit(2);
    }
}

void
cuP_test_bugf(char const *file, int line, char const *msg, ...)
{
    va_list va;
    va_start(va, msg);
    cuP_test_vbugf(file, line, msg, va);
    va_end(va);
}
