/*-*-C-*-
 * Copyright 2005  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cu/thread.h>
#include <cu/hash.h>

cu_mutex_t cuP_pmutex_arr[cuP_PMUTEX_CNT];

void
cu_pmutex_lock(void *ptr)
{
    cu_mutex_lock(cu_pmutex_mutex(ptr));
}

cu_bool_t
cu_pmutex_trylock(void *ptr)
{
    return cu_mutex_trylock(cu_pmutex_mutex(ptr));
}

void
cuP_pmutex_unlock(void *ptr)
{
    cu_mutex_unlock(cu_pmutex_mutex(ptr));
}

void
cuP_thread_init(void)
{
    size_t i;
    for (i = 0; i < cuP_PMUTEX_CNT; ++i)
	cu_mutex_cct(&cuP_pmutex_arr[i]);
}
