/*-*-C-*-
 * Copyright 2005  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CU_WORDARR_H
#define CU_WORDARR_H

#include <cu/fwd.h>
#include <cu/hcons.h>

CU_BEGIN_DECLARATIONS

CU_SINLINE cu_bool_t
cu_wordarr_eq(cu_word_t *arr0, cu_word_t *arr1, size_t cnt)
{
    while (cnt--)
	if (*arr0++ != *arr1++)
	    return cu_false;
    return cu_true;
}

CU_SINLINE void
cu_wordarr_copy(cu_word_t *dst, cu_word_t *src, size_t cnt)
{
    while (cnt--)
	*dst++ = *src++;
}

CU_SINLINE cu_hash_t
cu_wordarr_hash(cu_word_t *src, size_t cnt, cu_hash_t hash)
{
    while (cnt--) {
	hash += *src++;
	hash = cu_hash_mix(hash);
    }
    return hash;
}

CU_END_DECLARATIONS

#endif
