/*-*-C-*-
 * Copyright 2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#define CUCON_BITVECT_C
#include <cucon/bitvect.h>
#include <cu/memory.h>
#include <string.h>

#define BITVECT_ARRAY_SIZE(size)			\
	((size + sizeof(cuconP_bitvect_word_t) - 1)	\
	 /cuconP_bitvect_word_width)

void
cucon_bitvect_cct_uninit(cucon_bitvect_t bv, size_t size)
{
    bv->size = size;
    bv->arr = cu_galloc(BITVECT_ARRAY_SIZE(size)*sizeof(cuconP_bitvect_word_t));
}

cucon_bitvect_t
cucon_bitvect_new_uninit(size_t size)
{
    cucon_bitvect_t bv = cu_gnew(struct cucon_bitvect_s);
    cucon_bitvect_cct_uninit(bv, size);
    return bv;
}

void
cucon_bitvect_cct_fill(cucon_bitvect_t bv, size_t size, cu_bool_t val)
{
    bv->size = size;
    bv->arr = cu_galloc(BITVECT_ARRAY_SIZE(size)*sizeof(cuconP_bitvect_word_t));
    memset(bv->arr, (val? 0xff : 0),
	   BITVECT_ARRAY_SIZE(size)*sizeof(cuconP_bitvect_word_t));
}

cucon_bitvect_t
cucon_bitvect_new_fill(size_t size, cu_bool_t val)
{
    cucon_bitvect_t bv = cu_gnew(struct cucon_bitvect_s);
    cucon_bitvect_cct_fill(bv, size, val);
    return bv;
}

void
cucon_bitvect_cct_copy(cucon_bitvect_t bv, cucon_bitvect_t bv_src)
{
    size_t size = bv_src->size;
    bv->size = size;
    bv->arr = cu_galloc(BITVECT_ARRAY_SIZE(size)*sizeof(cuconP_bitvect_word_t));
}

cucon_bitvect_t
cucon_bitvect_new_copy(cucon_bitvect_t bv_src)
{
    cucon_bitvect_t bv = cu_gnew(struct cucon_bitvect_s);
    cucon_bitvect_cct_copy(bv, bv_src);
    return bv;
}

void
cucon_bitvect_fill(cucon_bitvect_t bv, cu_bool_t val)
{
    memset(bv->arr, (val? 0xff : 0),
	   BITVECT_ARRAY_SIZE(bv->size)*sizeof(cuconP_bitvect_word_t));
}
