#include <cucon/fwd.h>
#include <cucon/hset.h>
#include <stdlib.h>
#include <assert.h>

cu_clop_def(eq, cu_bool_t, void *p0, void *p1)
{
    return p0 == p1;
}

cu_clop_def(hash, cu_hash_t, void *p)
{
    return (cu_hash_t)p >> 1;
}

int
main()
{
    size_t const n_ins = 100000;
    size_t i;
    cucon_hset_t hs;
    cu_init();

    hs = cucon_hset_new(eq, hash);
    for (i = 0; i < n_ins; ++i)
	if (cucon_hset_insert(hs, (void*)i) != NULL)
	    assert(!"unexpected degeneracy");
    for (i = 0; i < n_ins; i += 2)
	if (cucon_hset_erase(hs, (void*)i) != (void*)i)
	    assert(!"lost value");
    for (i = 0; i < n_ins; ++i) {
	void *key = cucon_hset_find(hs, (void*)i);
	if (i % 2)
	    assert(key == (void*)i);
	else
	    assert(key == NULL);
    }
    return 0;
}
