/*-*-C-*-
 * Copyright 2002--2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: list.c,v 1.20 2003/09/28 21:41:28 petter Exp $
 */


#include <cucon/list.h>
#include <cu/memory.h>

struct cucon_list_s cuconP_list_empty;

void
cucon_list_cct(cucon_list_t list)
{
    list->eol.next = &list->eol;
    list->eol.prev = &list->eol;
}

void
cucon_list_cct_copy_ptr(cucon_list_t dst, cucon_list_t src)
{
    cucon_list_it_t it;
    cucon_list_cct(dst);
    for (it = cucon_list_begin(src); it != cucon_list_end(src);
	 it = cucon_list_it_next(it))
	cucon_list_append_ptr(dst, cucon_list_it_get_ptr(it));
}

cucon_list_t
cucon_list_new(void)
{
    cucon_list_t lst = cu_gnew(struct cucon_list_s);
    cucon_list_cct(lst);
    return lst;
}

cu_bool_fast_t
cucon_list_is_empty(cucon_list_t list)
{
    return list->eol.next == &list->eol;
}

cu_bool_fast_t
cucon_list_is_empty_or_singular(cucon_list_t list)
{
    return list->eol.next == list->eol.prev;
}

cu_bool_fast_t
cucon_list_is_singular(cucon_list_t list)
{
    return list->eol.next != &list->eol
	&& list->eol.next == list->eol.prev;
}

size_t
cucon_list_count(cucon_list_t list)
{
    cucon_list_it_t it;
    size_t i = 0;
    for (it = cucon_list_begin(list); it != cucon_list_end(list);
	 it = cucon_list_it_next(it))
	++i;
    return i;
}

cucon_list_it_t
cucon_list_insert_it(cucon_list_it_t it, cucon_list_it_t node)
{
    /* Erase. */
    node->next->prev = node->prev;
    node->prev->next = node->next;
    /* Re-insert. */
    node->next = it;
    node->prev = it->prev;
    node->prev->next = node;
    it->prev = node;
    return node;
}

cucon_list_it_t
cucon_list_insert_mem(cucon_list_it_t it, size_t size)
{
    struct cucon_list_node_s *it_new
	= cu_galloc(sizeof(struct cucon_list_node_s) + size);
    it_new->next = it;
    it_new->prev = it->prev;
    it->prev = it_new;
    it_new->prev->next = it_new;
    return it_new;
}

cucon_list_it_t
cucon_list_insert_ptr(cucon_list_it_t it, void *ptr)
{
    struct cucon_list_node_s *it_new
	= cu_galloc(sizeof(struct cucon_list_node_s)+sizeof(void*));
    it_new->next = it;
    it_new->prev = it->prev;
    it->prev = it_new;
    it_new->prev->next = it_new;
    cucon_list_it_set_ptr(it_new, ptr);
    return it_new;
}

cucon_list_it_t
cucon_list_insert_node_cct(cucon_list_it_t it, cucon_list_it_t newnode)
{
    newnode->next = it;
    newnode->prev = it->prev;
    newnode->prev->next = newnode;
    it->prev = newnode;
    return newnode;
}

void *
cucon_list_extract_mem(cucon_list_it_t it)
{
    it->next->prev = it->prev;
    it->prev->next = it->next;
    it->next = it->prev = NULL;
    return cucon_list_it_get_mem(it);
}

void *
cucon_list_extract_ptr(cucon_list_it_t it)
{
    void *ptr = cucon_list_it_get_ptr(it);
    it->next->prev = it->prev;
    it->prev->next = it->next;
    cu_gfree(it);
    return ptr;
}

cucon_list_it_t
cucon_list_it_erase(cucon_list_it_t it)
{
    it->next->prev = it->prev;
    it->prev->next = it->next;
    return it->next;
}

cucon_list_it_t
cucon_list_find_ptr(cucon_list_t lst, void *ptr)
{
    cucon_list_it_t it;
    for (it = cucon_list_begin(lst);
	 it != cucon_list_end(lst); it = cucon_list_it_next(it))
	if (cucon_list_it_get_ptr(it) == ptr)
	    break;
    return it;
}

cucon_list_it_t
cucon_list_erase_ptr(cucon_list_t lst, void *ptr)
{
    cucon_list_it_t it;
    for (it = cucon_list_begin(lst);
	 it != cucon_list_end(lst); it = cucon_list_it_next(it))
	if (cucon_list_it_get_ptr(it) == ptr)
	    return cucon_list_it_erase(it);
    return it;
}

size_t
cucon_list_erase_all_ptr(cucon_list_t lst, void *ptr)
{
    size_t count = 0;
    cucon_list_it_t it = cucon_list_begin(lst);
    while (it != cucon_list_end(lst)) {
	if (cucon_list_it_get_ptr(it) == ptr) {
	    ++count;
	    it = cucon_list_it_erase(it);
	}
	else
	    it = cucon_list_it_next(it);
    }
    return count;
}

void
cucon_list_rotate_backwards(cucon_list_t lst)
{
    if (cucon_list_is_empty_or_singular(lst))
	return;
    lst->eol.prev->next = lst->eol.next;
    lst->eol.next->prev = lst->eol.prev;
    lst->eol.prev = lst->eol.next;
    lst->eol.next = lst->eol.next->next;
    lst->eol.prev->next = &lst->eol;
    lst->eol.next->prev = &lst->eol;
}

void
cucon_list_it_for_mem(cucon_list_it_t first, cucon_list_it_t last,
		    cu_clop(proc, void, void *))
{
    while (first != last) {
	cu_call(proc, cucon_list_it_get_mem(first));
	first = cucon_list_it_next(first);
    }
}

cucon_list_it_t
cucon_list_append_list_dct(cucon_list_t lst, cucon_list_t dlst)
{
    cucon_list_it_t mid = dlst->eol.next;
    mid->prev = lst->eol.prev;
    mid->prev->next = mid;
    lst->eol.prev = dlst->eol.prev;
    lst->eol.prev->next = &lst->eol;
#ifndef CU_NDEBUG
    dlst->eol.next = NULL;
    dlst->eol.prev = NULL;
#endif
    return mid;
}

cucon_list_it_t
cucon_list_prepend_list_dct(cucon_list_t lst, cucon_list_t dlst)
{
    cucon_list_it_t mid = lst->eol.prev;
    mid->prev = dlst->eol.prev;
    mid->prev->next = mid;
    lst->eol.next = dlst->eol.next;
    lst->eol.next->prev = &lst->eol;
#ifndef CU_NDEBUG
    dlst->eol.next = NULL;
    dlst->eol.prev = NULL;
#endif
    return mid;
}

void
cuconP_list_init(void)
{
    cucon_list_cct(&cuconP_list_empty);
}

