#include <cucon/pmap.h>
#include <cu/memory.h>
#include <cu/debug.h>

#include <assert.h>
#include <cu/clos.h>
#include <stdio.h>


cu_clos_def(count,
	    void cu_proto(void const *key, void *data),
	    (int cnt;))
{
    cu_clos_self(count);
    ++self->cnt;
}

int
pmap_count(cucon_pmap_t pmap)
{
    count_t cl;
    cu_clos_cct(&cl, count);
    cl.cnt = 0;
    cucon_pmap_iter_mem(pmap, cu_clos_ref(&cl));
    return cl.cnt;
}

void
test_strong()
{
    int i;
    cucon_pmap_t pmap = cucon_pmap_new();
    void *somekey;
    cucon_pmap_insert_ptr(pmap, somekey = cu_galloc(1), NULL);
    for (i = 0; i < 10; ++i)
	cucon_pmap_insert_ptr(pmap, cu_galloc(1), NULL);
    GC_gcollect();
    assert(cucon_pmap_size(pmap) == 11);
    cucon_pmap_erase(pmap, somekey);
    assert(cucon_pmap_size(pmap) == 10);
}

cu_clos_def(test_isecn_union_cb,
	    void cu_proto(uintptr_t key),
	    ( uintptr_t sum;
	      cu_bool_t is_union; ))
{
    cu_clos_self(test_isecn_union_cb);
    self->sum += key;
    if (!self->is_union)
	cu_debug_assert((key & 3) == 3);
}

void
test_isecn_union()
{
    size_t N = 10000;
    size_t n;
    struct cucon_umap_s S, T;
    size_t S_cnt = 0;
    size_t T_cnt = 0;
    uintptr_t sum = 0;
    test_isecn_union_cb_t cb;
    cucon_umap_cct(&S);
    cucon_umap_cct(&T);
    for (n = 0; n < N; ++n) {
	uintptr_t key = lrand48() % N;
	if (key & 1) {
	    if (cucon_umap_insert_void(&S, key)) {
		sum += key;
		++S_cnt;
	    }
	}
	if (key & 2) {
	    if (cucon_umap_insert_void(&T, key)) {
		sum += key;
		++T_cnt;
	    }
	}
    }
    cucon_umap_assign_isecn_union(&S, &T);
    cu_debug_assert(cucon_umap_size(&S) + cucon_umap_size(&T) == S_cnt + T_cnt);
    cu_clos_cct(&cb, test_isecn_union_cb);
    cb.sum = 0;
    cb.is_union = cu_false;
    cucon_umap_iter_keys(&S, cu_clos_ref(&cb));
    cb.is_union = cu_true;
    cucon_umap_iter_keys(&T, cu_clos_ref(&cb));
    cu_debug_assert(cb.sum == sum);
}

int
main()
{
    int i;
    cu_init();
    test_strong();
    for (i = 0; i < 100; ++i)
	test_isecn_union();
    GC_gcollect();
    return 0;
}
