#include <cucon/pritree.h>
#include <cu/memory.h>
#include <assert.h>

int
main()
{
    size_t N = 100000;
    int n;
    struct cucon_pritree_s pritree;
    double x = 1.0;
    cucon_prinode_t *tv;

    cu_init();

    tv = cu_salloc(sizeof(cucon_prinode_t)*N);
    cucon_pritree_cct(&pritree);
    for (n = 0; n < N; ++n) {
	tv[n] = cu_gnew(struct cucon_prinode_s);
	cucon_pritree_insert_cct(&pritree, tv[n], drand48());
    }
    for (n = 0; n < N; ++n) {
	cucon_prinode_t prinode = cucon_pritree_front(&pritree);
	assert(prinode->priority <= x);
	x = prinode->priority;
	cucon_pritree_pop(&pritree);
    }
    assert(cucon_pritree_is_empty(&pritree));

    for (n = 0; n < N; ++n) {
	tv[n] = cu_gnew(struct cucon_prinode_s);
	cucon_pritree_insert_cct(&pritree, tv[n], drand48());
    }
    for (n = 0; n < N/2; ++n)
	cucon_pritree_change_priority(&pritree, tv[2*n], drand48());
    x = 1.0;
    for (n = 0; n < N; ++n) {
	cucon_prinode_t prinode = cucon_pritree_front(&pritree);
	assert(prinode->priority <= x);
	x = prinode->priority;
	if (n % 2 == 0)
	    cucon_pritree_change_priority(&pritree,
					cucon_pritree_front(&pritree), -1.0);
	else
	    cucon_pritree_pop(&pritree);
    }
    for (n = 0; n < N/2; ++n)
	cucon_pritree_pop(&pritree);
    assert(cucon_pritree_is_empty(&pritree));

    return 0;
}
