#include <cucon/queue.h>
#include <assert.h>
#include <stdlib.h>
#include <string.h>

#define REPETITIONS 100000

int
main()
{
    int i;
    int j = 0, k = 0;
    int s = 0, t = 0;
    int size_arr[REPETITIONS];
    cucon_queue_t q;

    cu_init();

    q = cucon_queue_new();
    for (i = 0; i < REPETITIONS; ++i) {
	if (lrand48() % 2) {
	    size_t size = size_arr[j++] = lrand48() % 300;
	    void *ptr = cucon_queue_push_mem(q, size);
	    memset(ptr, s++, size);
	}
	else if (j == k)
	    assert(cucon_queue_is_empty(q));
	else {
	    size_t l;
	    size_t size = size_arr[k++];
	    char *ptr;
	    assert(size == 0 || !cucon_queue_is_empty(q));
	    ptr = cucon_queue_front_mem(q);
	    for (l = 0; l < size; ++l)
		assert(ptr[l] == (char)t);
	    ++t;
	    cucon_queue_pop_mem(q, size);
	}
    }
    return 0;
}
