/*-*-C-*-
 * Copyright 2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cucon/rbset.h>
#include <cu/memory.h>
#include <cu/str.h>
#include <cu/clos.h>

void
cucon_rbset_cct(cucon_rbset_t rbset, cu_clop(cmp, int, void *, void *))
{
    cucon_rbtree_cct(cu_upcast(cucon_rbtree_s, rbset));
    rbset->cmp = cmp;
}

cucon_rbset_t
cucon_rbset_new(cu_clop(cmp, int, void *, void *))
{
    cucon_rbset_t rbset = cu_gnew(struct cucon_rbset_s);
    cucon_rbtree_cct(cu_upcast(cucon_rbtree_s, rbset));
    rbset->cmp = cmp;
    return rbset;
}

void
cucon_rbset_cct_str_cmp(cucon_rbset_t rbset)
{
    cucon_rbset_cct(rbset, (cu_clop(, int, void *, void *))cu_str_cmp_clop);
}

cucon_rbset_t
cucon_rbset_new_str_cmp(void)
{
    return cucon_rbset_new((cu_clop(, int, void *, void *))cu_str_cmp_clop);
}
