#include <cucon/rbtree.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

/* #define DUMP */

cu_clos_def(int_compare,
	    int cu_proto(void *slot),
	    (int elt;))
{
    cu_clos_self(int_compare);
    if (self->elt < *(int *)slot)
	return -1;
    else if (self->elt > *(int *)slot)
	return 1;
    else
	return 0;
}

#ifdef DUMP
void
print_int_label(void *slot, FILE *out)
{
    fprintf(out, "%d", *(int *)slot);
}
void
print_elt(void *slot)
{
    printf(" %d", *(int *)slot);
}
#endif


int
main()
{
    int_compare_t compare;
    size_t i;
#ifdef DUMP
#  define max_elt 0x80
#else
#  define max_elt 0x8000
#endif
    static int elt_arr[max_elt];
    cucon_rbtree_t tree;

    cu_init();

    tree = cucon_rbtree_new();
    cu_clos_cct(&compare, int_compare);
    memset(elt_arr, 0, sizeof(elt_arr));
    for (i = 0; i < max_elt; ++i) {
	int elt = lrand48() % max_elt;
	int *slot;
	compare.elt = elt;
	if (cucon_rbtree_insert_mem(tree, cu_clos_ref(&compare),
				  sizeof(int), (void*)&slot))
	    *slot = elt;
	else
	    assert(*slot == elt);
	elt_arr[elt] = 1;
    }
#ifdef DUMP
    {
	void cu_nonclos(cb)(void *);
	cu_nonclos_cct(&cb, print_elt);
	printf("/* Ordered contents:");
	cucon_rbtree_for_mem(tree, cu_nonclos_ref(&cb));
	printf(" */\n");
    }
#endif

    for (i = 0; i < max_elt; ++i) {
	int elt = lrand48() % max_elt;
	int *slot;
	compare.elt = elt;
	slot = cucon_rbtree_erase(tree, cu_clos_ref(&compare));
	if (slot) {
	    assert(*slot == elt);
	    assert(elt_arr[elt]);
	    elt_arr[elt] = 0;
	}
	else
	    assert(!elt_arr[elt]);
    }

#ifdef DUMP
    {
	void cu_nonclos(cb)(void *, FILE *);
	cu_nonclos_cct(&cb, print_int_label);
	cucon_rbtree_dump_as_graphviz(tree, cu_nonclos_ref(&cb), stdout);
    }
#endif

    for (i = 0; i < max_elt; ++i) {
	int *slot;
	compare.elt = i;
	slot = cucon_rbtree_find_mem(tree, cu_clos_ref(&compare));
	if (slot) {
	    assert(*slot == (int)i);
	    assert(elt_arr[i]);
	}
	else
	    assert(!elt_arr[i]);
    }
    return 0;
}
