/*-*-C-*-
 * Copyright 2003--2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CUCON_SLINK_H
#define CUCON_SLINK_H

#include <cucon/fwd.h>
#include <cu/memory.h>

CU_BEGIN_DECLARATIONS
/*!\file
 * \deprecated Not very useful. Use a next-link field instead. */

struct cucon_slink_s
{
    cucon_slink_t next;
};

cucon_slink_t cucon_slink_empty(void);
#define cucon_slink_empty() NULL

cu_bool_fast_t cucon_slink_is_empty(cucon_slink_t);
#define cucon_slink_is_empty(slink) ((slink) == (cucon_slink_t)NULL)

CU_SINLINE cucon_slink_t
cucon_slink_prepend_ptr(cucon_slink_t slink, void *ptr)
{
    cucon_slink_t l = cu_galloc(cu_aligned_ceil(sizeof(struct cucon_slink_s))
			       + sizeof(void *));
    l->next = slink;
    *(void**)CU_ALIGNED_PTR_END(l) = ptr;
    return l;
}

CU_SINLINE cucon_slink_t
cucon_slink_prepend_mem(cucon_slink_t slink, size_t size)
{
    cucon_slink_t l = cu_galloc(cu_aligned_ceil(sizeof(struct cucon_slink_s))
			       + size);
    l->next = slink;
    return l;
}

void *cucon_slink_get_mem(cucon_slink_t);
#define cucon_slink_get_mem(slink) (CU_ALIGNED_MARG_END(cucon_slink_t, slink))

void *cucon_slink_get_ptr(cucon_slink_t);
#define cucon_slink_get_ptr(slink) (*(void**)cucon_slink_get_mem(slink))

cucon_slink_t cucon_slink_next(cucon_slink_t);
#define cucon_slink_next(slink) (CU_MARG(cucon_slink_t, slink)->next)

CU_END_DECLARATIONS

#endif
