#include <cucon/pmap.h>
#include <cucon/ucset.h>
#include <time.h>
#include <stdio.h>

#define NINS 2000
#define NFIND 2000
#define MOD 4000
#define REPEAT 500

void
bench()
{
    int i, j;
    clock_t ubt_tins = 0, umap_tins = 0;
    clock_t ubt_tfind = 0, umap_tfind = 0;
    for (j = 0; j < REPEAT; ++j) {
	cucon_ucset_t tree = NULL;
	cucon_umap_t umap = cucon_umap_new();
	for (i = 0; i < NINS; ++i) {
	    int j = lrand48() % MOD;
	    ubt_tins -= clock();
	    tree = cucon_ucset_insert(tree, j);
	    ubt_tins += clock();
	    umap_tins -= clock();
	    cucon_umap_insert_void(umap, j);
	    umap_tins += clock();
	}
	for (i = 0; i < NFIND; ++i) {
	    int j = lrand48() % MOD;
	    ubt_tfind -= clock();
	    cucon_ucset_find(tree, j);
	    ubt_tfind += clock();
	    umap_tfind -= clock();
	    cucon_umap_find_mem(umap, j);
	    umap_tfind += clock();
	}
    }
    printf("ubt_tins  = %lf\numap_tins = %lf\n",
	   ubt_tins/(double)CLOCKS_PER_SEC,
	   umap_tins/(double)CLOCKS_PER_SEC);
    printf("ubt_tfind  = %lf\numap_tfind = %lf\n",
	   ubt_tfind/(double)CLOCKS_PER_SEC,
	   umap_tfind/(double)CLOCKS_PER_SEC);
}

int
main()
{
    cu_init();
    bench();
    return 0;
}
