#include <cudyn/type.h>
#include <cudyn/misc.h>
#include <cuex/opr.h>
#include <cuex/ex.h>
#include <cuex/sig.h>

void
test_type(cuex_t ex)
{
    cudyn_type_t t = cudyn_type(ex);
    cu_debug_assert(t);
    cu_fprintf(stdout, "%! ↦ %! (%d bits aligned on %d bits)\n",
	       ex, t, cudyn_type_bitsize(t), cudyn_type_bitalign(t));
}

void
test()
{
    test_type(cuex_o2(gexpt, cudyn_int_type(), cudyn_int(4)));
    test_type(cuex_o2(gexpt, cudyn_bool_type(), cudyn_int(33)));
    test_type(cuex_o2(gprod, cudyn_int8_type(), cudyn_int16_type()));
    test_type(cuex_o2(gprod, cudyn_int8_type(), cudyn_int32_type()));
    test_type(cuex_sig_v(3,
		"x", cudyn_int8_type(), 
		"y", cudyn_float_type(),
		"cond", cudyn_bool_type()));
}


int
main()
{
    cuex_init();
    cu_debug_assert(cudyn_int_type());
    test();
    return 0;
}
