#include <cuex/algo.h>
#include <cuex/var.h>
#include <cuex/ex.h>
#include <cuex/opr.h>
#include <cudyn/misc.h>

cu_clop_def(is_const, cu_bool_t, cuex_t e)
{
    cu_verbf(0, "Test %! gives %d", e, !cuex_is_var(e));
    return !cuex_is_var(e);
}

cu_clop_def(show_tr, cuex_t, cuex_t e)
{
    cu_verbf(0, "Transforming %!", e);
    return cuex_o1(ptr_to, e);
}

void
test()
{
    cuex_t e =
	cuex_o2(gexpt,
		cuex_o2(gprod,
			cuex_o2(gprod, cudyn_int(0), cudyn_int(1)),
			cudyn_int(2)),
		cuex_o2(gprod, cudyn_int(1), cuex_var_new_e()));
    cuex_t ep = cuex_maxtrees_of_leaftest_tran(e, is_const, show_tr);
    cu_verbf(0, "Result: %!", ep);
}

cu_clos_def(msg_cb,
	    cuex_t cu_proto(cuex_t *arg_arr),
    (int i;))
{
    cu_clos_self(msg_cb);
    return cuex_ivar(cuex_qcode_u, self->i++);
}
cu_clos_def(msg_cb2,
	    cuex_t cu_proto(cuex_t e0, cuex_t e1),
    (int i;))
{
    cu_clos_self(msg_cb2);
    return cuex_ivar(cuex_qcode_u, self->i++);
}

void
test_msg()
{
    cuex_t e[2];
    cuex_t ep;
    msg_cb_t cb;
    msg_cb2_t cb2;
    e[0] = cuex_o2(gprod,
		   cuex_o2(gexpt, cudyn_int(1), cudyn_int(2)),
		   cuex_o2(gexpt, cuex_var_new_e(), cudyn_int(3)));
    e[1] = cuex_o2(gprod,
		   cuex_o2(gexpt,
			   cuex_o1(singleton, cudyn_int(4)),
			   cudyn_int(2)),
		   cuex_var_new_e());
    cu_clos_cct(&cb, msg_cb);
    cb.i = 0;
    ep = cuex_msg_unify_by_arr(2, e, cu_clos_ref(&cb));
    cu_verbf(0, "MSG(⟦%!⟧, ⟦%!⟧) = ⟦%!⟧", e[0], e[1], ep);
    cu_clos_cct(&cb2, msg_cb2);
    cb2.i = 0;
    cu_debug_assert(ep == cuex_msg_unify(e[0], e[1], cu_clos_ref(&cb2)));
}

int
main()
{
    cuex_init();
    test();
    test_msg();
    return 0;
}
