/*-*-C-*-
 * Copyright 2005  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cuex/misc.h>
#include <cu/dyn.h>

cuex_t
cuex_of_long(long i)
{
    return cuex_halloc_by_key(cudyn_stdtype_to_meta(cuexP_long_type),
			         sizeof(long), &i);
}

cudyn_stdtype_t cuexP_long_type;

void
cuexP_misc_init()
{
    cuexP_long_type = cudyn_stdtype_new_hcs(sizeof(long));
}
