/*!\defgroup cuex_opr_h cuex/opr.h: Operator Definitions
 * @{\ingroup cuex_mod
 */
/* !! This file is generated from cuex/opr.cuex-ot !!
 *
 * Copyright 2005  Petter Urkedal
 * 
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * All generated C names will have this prefix.
 * Operator indices starts here.  The ACI operators will start at
 * index_start + CUEX_ACI_OPR_START.
 * This is optional. It indicates the mimimum first free index. It can be used
 * to indicate to other projects the range of indices we have reserved. An
 * error will be issued if we use more indices than fits from index_start
 * to exclusive index_end.
 * The implementation must include a header which declares the operator
 * constructors.
 * Documentation comments are prefixed with ##. They are used to generate
 * Doxygen compatible documentation in the generated source.
 * Likewise, an indented ## comment after a definition will produce a
 * documentation comment attached to the corresponding definition.
 */

#ifndef CUEX_H
#define CUEX_H

#include <cuex/ex.h>
#include <cuex/oprinfo.h>
/*!Operator of the null-expression */
#define cuex_opr_null_0 cuex_opr(0, 0)
/*!Operator of the expression representing unknown/uspecified */
#define cuex_opr_unknown_0 cuex_opr(1, 0)
/*!Lambda abstraction. */
#define cuex_opr_lambda_2 cuex_opr(32, 2)
/*!Lambda abstraction with type annotation.  The type of the full
 * lamda expression (not just the result) is stored in the last
 * operand. */
#define cuex_opr_lambda_ta_3 cuex_opr(32, 3)
/*!Universal quantisation. */
#define cuex_opr_forall_2 cuex_opr(33, 2)
/*!Universal quantisation over given domain. */
#define cuex_opr_forall_3 cuex_opr(33, 3)
/*!Existential quantisation. */
#define cuex_opr_exists_2 cuex_opr(34, 2)
/*!Existential quantisation over given domain. */
#define cuex_opr_exists_3 cuex_opr(34, 3)
/*!Bind a variable to an expression in a block.
 * E.g. \code let x = sin φ in x⋅x\endcode */
#define cuex_opr_let_3 cuex_opr(35, 3)
/*!Bind a variable to an expression in the expression self. */
#define cuex_opr_letself_2 cuex_opr(35, 2)
/*!Internal use.  Used in substitutions to block variables from
 * binding. */
#define cuex_opr_subst_block_1 cuex_opr(64, 1)
/*!Function or constructor application. */
#define cuex_opr_apply_2 cuex_opr(64, 2)
/*!An associative operator which combines two objects
 * \e x ∈ \e T and \e y ∈ \e U into (\e x, \e y) ∈ \e T × \e U. */
#define cuex_opr_tuple_2a cuex_opr(65, 0)
/*!A n-ary version of tuple/2a. */
#define cuex_opr_tuple_r(r) cuex_opr(66, r)
/*!True iff \a opr is \ref cuex_opr_tuple_r(\e r) of any arity \e r. */
#define cuex_opr_is_tuple(opr) (cuex_opr_index(opr) == 66)
/*!Represents a recursive expression, where the LHS is a
 * \ref cuex_opr_tuple_r of mutually recursive terms which by this
 * construct are bound to rvars with indices corresponding to the
 * component number both on the LHS and RHS.  The RHS is the value
 * of the whole expression. */
#define cuex_opr_rbind_2 cuex_opr(67, 2)
/*!An if-then-else conditional expression. */
#define cuex_opr_if_3 cuex_opr(67, 3)
/*!A general product operator.
 * Used for direct product of types, in which case it is
 * non-associative. */
#define cuex_opr_gprod_2 cuex_opr(68, 2)
/*!A general exponentiation operator.
 * Used for direct exponents of types. */
#define cuex_opr_gexpt_2 cuex_opr(69, 2)
/*!Function type arrow, similar to set exponent written reversly */
#define cuex_opr_farrow_2 cuex_opr(70, 2)
/*!Function type arrow with indication of native C ABI. */
#define cuex_opr_farrow_native_2 cuex_opr(71, 2)
/*!A pointer type. */
#define cuex_opr_ptr_to_1 cuex_opr(67, 1)
/*!Associative, commutative and idempotent product operator. */
#define cuex_opr_prod_2aci1 cuex_aci_opr(67, 1)
/*!The operator of the identity element of \ref cuex_opr_prod_2aci1. */
#define cuex_opr_prod_0aci0 cuex_aci_identity_opr(67)
/*!An operator which combines labelled types or signatures into
 * signatures.  Let's call it a signature direct product. */
#define cuex_opr_sigprod_2aci2 cuex_aci_opr_with_ctor(68, 2)
/*!The operator of the identity element of \ref cuex_opr_sigprod_2aci2. */
#define cuex_opr_sigprod_0aci0 cuex_aci_identity_opr(68)
/*!Inject the LHS signature into the RHS signature so that the
 * layout of the LHS is intact.  A lookup will search both
 * operands recursively.  Thus, several base signatures can be
 * injected into the same signature by right-associated application
 * of sigbase/2, e.g.
 * (sigbase base_sig_0 (sigbase base_sig_1 target_sig)).  The client
 * must make sure to canonically order the bases according to
 * their type if equality is needed for signatures. */
#define cuex_opr_sigbase_2 cuex_opr_with_ctor(72, 2)
/*!Expresses the singleton set of the operand.  This can be used as
 * a type, which will have zero size and 1 bit alignment. */
#define cuex_opr_singleton_1 cuex_opr(68, 1)
#define cuex_opr_vtable_slots_1 cuex_opr(69, 1)
/*!Joins components of a structure expression. */
#define cuex_opr_structjoin_2aci2 cuex_aci_opr(69, 2)
/*!The operator of the identity element of \ref cuex_opr_structjoin_2aci2. */
#define cuex_opr_structjoin_0aci0 cuex_aci_identity_opr(69)
/*!Discriminate union of labelled types. */
#define cuex_opr_dunion_2aci2 cuex_aci_opr_with_ctor(70, 2)
/*!The operator of the identity element of \ref cuex_opr_dunion_2aci2. */
#define cuex_opr_dunion_0aci0 cuex_aci_identity_opr(70)
/*!An operator whose generators are singular sets, and which
 * join is unions of sets. */
#define cuex_opr_setjoin_2aci1 cuex_aci_opr(71, 1)
/*!The operator of the identity element of \ref cuex_opr_setjoin_2aci1. */
#define cuex_opr_setjoin_0aci0 cuex_aci_identity_opr(71)
/*!\b operands: (\e type, \e expr)\n 
 * A type annotation */
#define cuex_opr_ident_ta_2 cuex_opr(73, 2)
/*!\b operands: (\e type, \e idr, \e struct)\n  */
#define cuex_opr_load_ta_3 cuex_opr(73, 3)
/*!\b operands: (\e type, \e fn, \e args...)\n  */
#define cuex_opr_call_ta_r(r) cuex_opr(74, r)
/*!True iff \a opr is \ref cuex_opr_call_ta_r(\e r) of any arity \e r. */
#define cuex_opr_is_call_ta(opr) (cuex_opr_index(opr) == 74)

/*!True iff the operator is a scoping operator.  Such an operator
 * is assumed to have a variable as the first operand, which will
 * be locally bound in the remaining operands.*/
CU_SINLINE cu_bool_t cuex_opr_is_scoping(cuex_meta_t opr)
{
    cuex_meta_t i = cuex_opr_index(opr);
    return 32 <= i && i < 64;
}


CU_SINLINE cu_bool_t cuex_opr_is_ta(cuex_meta_t opr)
{
    cuex_meta_t i = cuex_opr_index(opr);
    return 73 <= i && i < 75;
}

/*!Returns <tt>cuex_opn(cuex_opr_<i>NAME</i>_0)</tt>.
 * This is a convenient and arity-safe way to apply operators from the
 * <tt>cuex_</tt> namespace. */
#define cuex_o0(NAME) cuex_opn(cuex_opr_##NAME##_0)
/*!Returns <tt>cuex_opn(cuex_opr_<i>NAME</i>_1, x0)</tt>.
 * This is a convenient and arity-safe way to apply operators from the
 * <tt>cuex_</tt> namespace. */
#define cuex_o1(NAME, x0) cuex_opn(cuex_opr_##NAME##_1, x0)
/*!Returns <tt>cuex_opn(cuex_opr_<i>NAME</i>_2, x0, x1)</tt>.
 * This is a convenient and arity-safe way to apply operators from the
 * <tt>cuex_</tt> namespace. */
#define cuex_o2(NAME, x0, x1) cuex_opn(cuex_opr_##NAME##_2, x0, x1)
/*!Returns <tt>cuex_opn(cuex_opr_<i>NAME</i>_3, x0, x1, x2)</tt>.
 * This is a convenient and arity-safe way to apply operators from the
 * <tt>cuex_</tt> namespace. */
#define cuex_o3(NAME, x0, x1, x2) cuex_opn(cuex_opr_##NAME##_3, x0, x1, x2)
/*!@}
 */
#endif
