/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CUEX_OPR_PRIV_H
#define CUEX_OPR_PRIV_H

#include <cuex/fwd.h>

CU_BEGIN_DECLARATIONS

/* sigprod/2aci2 and sigbase/2
 * --------------------------- */

typedef struct cuex_opr_sigprod_cache_s *cuex_opr_sigprod_cache_t;
struct cuex_opr_sigprod_cache_s
{
    cu_offset_t alloc_size[CUCONF_LOG2_MAXALIGN + 2];
};
#define cuex_opr_sigprod_2aci2_cache_size \
	sizeof(struct cuex_opr_sigprod_cache_s)
void cuex_opr_sigprod_2aci2_cache_cct(cuex_opn_t);

#define cuex_opr_sigbase_cache_s cuex_opr_sigprod_cache_s
#define cuex_opr_sigbase_2_cache_size \
	sizeof(struct cuex_opr_sigbase_cache_s)
void cuex_opr_sigbase_2_cache_cct(cuex_opn_t);


/* dunion/2aci2
 * ------------ */

typedef struct cuex_opr_dunion_cache_s *cuex_opr_dunion_cache_t;
struct cuex_opr_dunion_cache_s
{
    int count;
};
#define cuex_opr_dunion_2aci2_cache_size \
	sizeof(struct cuex_opr_dunion_cache_s)
void cuex_opr_dunion_2aci2_cache_cct(cuex_opn_t);

CU_END_DECLARATIONS

#endif
