#include <cuex/subst.h>
#include <cuex/opn.h>
#include <cucon/pmap.h>


cuex_subst_t sig;
struct cucon_pmap_s ex_to_var;

void
ins(cuex_t ex)
{
    cuex_var_t var = cuex_subst_insert_fragment_accum(sig, &ex_to_var, ex, NULL);
    cu_verbf(0, "%! ↦ %!\n", cuex_var_to_ex(var), ex);
}

int
main()
{
    cuex_t v0, v1;
    cuex_init();
    sig = cuex_subst_new_uw();
    v0 = cuex_var_to_ex(cuex_var_new(cuex_qcode_active_s));
    v1 = cuex_var_to_ex(cuex_var_new(cuex_qcode_active_s));
    cucon_pmap_cct(&ex_to_var);
    ins(cuex_opn(cuex_opr(0x100, 2),
		 cuex_opn(cuex_opr(0x101, 2), v0, v1),
		 cuex_opn(cuex_opr(0x101, 2), v0, v1)));
    ins(cuex_opn(cuex_opr(0x101, 2), v0, v1));
    cuex_subst_dump(sig, stdout);
    return 0;
}
