#include <cuex/subst.h>
#include <cu/str.h>
#include <cuex/pvar.h>
#include <cu/idr.h>
#include <cuex/opr.h>
#include <cuex/opn.h>
#include <cu/test.h>

static void
unify(cuex_subst_t subst, cuex_t ex0, cuex_t ex1, cu_bool_t expect)
{
    if (!!cuex_subst_unify(subst, ex0, ex1) != !!expect) {
	if (expect)
	    cu_test_bugf("Could not unify %! with %!.\n", ex0, ex1);
	else
	    cu_test_bugf("Unified %! with %!.\n", ex0, ex1);
    }
}

int
main()
{
    cuex_subst_t sig0;
    cuex_subst_t sig1;
    cuex_t v[10];
    cuex_t c[2];
    int i;
    cuex_init();
    cu_test_on_bug(cu_test_bugaction_cont);
    sig0 = cuex_subst_new_uw();
    for (i = 0; i < 10; ++i)
	v[i] = cuex_var_new_u();
	//v[i] = cuex_pvar_to_ex(
	//    cuex_pvar_new_named(cuex_qcode_active_s,
	//		      cu_str_to_cstr(cu_str_new_fmt("x%d", i))));
    c[0] = cu_idr_by_cstr("a");
    c[1] = cu_idr_by_cstr("b");
    unify(sig0, v[0], v[1], cu_true);
    unify(sig0, v[0], cuex_o2(apply, v[2], c[0]), cu_true);
    cu_test_assert_ptr_eq(cuex_subst_cref(sig0, cuex_var_from_ex(v[0])),
			  cuex_subst_cref(sig0, cuex_var_from_ex(v[1])));
    unify(sig0, v[2], v[1], cu_false);
    unify(sig0, v[3], v[4], cu_true);

    sig1 = cuex_subst_new_uw_clone(sig0);
    unify(sig1, v[5], cuex_o2(lambda, v[0], c[1]), cu_true);
    unify(sig1, v[5], v[3], cu_true);
    cu_test_assert_ptr_eq(cuex_subst_cref(sig1, cuex_var_from_ex(v[5])),
			  cuex_subst_cref(sig1, cuex_var_from_ex(v[3])));
    cu_test_assert(sig1->shadowed);
    cuex_subst_dump(sig1, stdout);
    printf("Last subst prettyprited:\n\t");
    cuex_subst_print(sig1, stdout, "\n\t");
    for (i = 0; i < 60; ++i)
	cuex_subst_cref(sig1, cuex_var_from_ex(v[9]));
    fputc('\n', stdout);
    cu_test_assert(!sig1->shadowed);
    cu_test_assert_ptr_eq(cuex_subst_cref(sig1, cuex_var_from_ex(v[5])),
			  cuex_subst_cref(sig1, cuex_var_from_ex(v[3])));

    sig0 = cuex_subst_new(cuex_qcset_uw);
    unify(sig0, v[1], v[0], cu_true);
    unify(sig0, v[1], v[4], cu_true);
    unify(sig0, v[1], v[3], cu_true);
    unify(sig0, v[2], v[0], cu_true);
    cu_test_assert(cuex_subst_lookup(sig0, cuex_var_from_ex(v[1])) == v[3]);

    /* non-idempotent substitutions */
    sig0 = cuex_subst_new_nonidem(cuex_qcset_uw);
    unify(sig0, v[0], cuex_o2(apply, v[1], v[1]), cu_true);
    unify(sig0, v[1], cuex_o2(apply, v[0], v[0]), cu_true);
    unify(sig0, v[2], v[0], cu_true);
    unify(sig0, v[3], v[1], cu_true);
    unify(sig0, v[4], cuex_o2(apply, v[0], v[1]), cu_true);
    cuex_subst_render_idempotent(sig0);
    cuex_subst_dump(sig0, stdout);

    sig0 = cuex_subst_new_nonidem(cuex_qcset_uw);
    unify(sig0, v[0], cuex_o2(farrow, v[1], v[2]), cu_true);
    unify(sig0, v[1], cuex_o2(farrow, v[2], v[0]), cu_true);
    unify(sig0, v[2], cuex_o2(farrow, v[0], v[1]), cu_true);
    cuex_subst_render_idempotent(sig0);
    cuex_subst_dump(sig0, stdout);

    return !!cu_test_bug_count();
}
