/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cuex/opr.h>
#include <cuex/type.h>
#include <cuex/sig.h>
#include <cuex/algo.h>
#include <cuex/tvar.h>
#include <cudyn/type.h>
#include <cudyn/misc.h>

cu_rank_t
cuex_farrow_arity(cuex_t type)
{
    cu_rank_t r = 0;
    for (;;) switch (cuex_meta(type)) {
	case cuex_opr_forall_2:
	    type = cuex_opn_at(type, 1);
	    break;
	case cuex_opr_farrow_2:
	    ++r;
	    type = cuex_opn_at(type, 1);
	    break;
	default:
	    return r;
    }
}

size_t
cuex_type_bitsize(cuex_t type)
{
    cuex_meta_t meta;
tailcall:
    if (cudyn_is_type(type)) {
	if (cudyn_type_typekind(type) != cudyn_typekind_by_expr)
	    return cudyn_type_bitsize(type);
	else
	    type = cudyn_type_as_expr(type);
    }

    meta = cuex_meta(type);
    if (cuex_is_tvarmeta_q(meta, cuex_qcode_u))
	return 8*sizeof(void *);
    else if (cuex_meta_is_opr(meta))
	switch (cuex_meta(type)) {
		cuex_t ty0;
	    case cuex_opr_forall_2:
		type = cuex_opn_at(type, 1);
		goto tailcall;
	    case cuex_opr_sigprod_2aci2:
	    case cuex_opr_sigbase_2:
		return cuex_sig_bitsize(type);
	    case cuex_opr_sigprod_0aci0:
	    case cuex_opr_singleton_1:
		return 0;
	    case cuex_opr_gexpt_2:
		return cuex_type_bitsize(cuex_opn_at(type, 0))
		     * cudyn_castget_ulong(cuex_opn_at(type, 1));
	    case cuex_opr_ptr_to_1:
		return 8*sizeof(void *);
	    case cuex_opr_farrow_2:
	    case cuex_opr_farrow_native_2:
		return 8*sizeof(void *);
	    case cuex_opr_vtable_slots_1:
		ty0 = cuex_opn_at(type, 0);
		if (cuex_is_unknown(ty0))
		    return 0;
		return 8*sizeof(void *)*(cuex_farrow_arity(ty0) + 1);
	    case cuex_opr_unknown_0:
		return 0;
	    default:
		cu_debug_unreachable();
		return 0;
	}
    else
	cu_debug_unreachable();
}

cu_offset_t
cuex_type_bitalign(cuex_t type)
{
    if (cudyn_is_type(type))
	return cudyn_type_bitalign(type);
    switch (cuex_meta(type)) {
	case cuex_opr_sigprod_0aci0:
	case cuex_opr_singleton_1:
	    return 1;
	case cuex_opr_sigprod_2aci2:
	case cuex_opr_sigbase_2:
	    return cuex_sig_bitalign(type);
	default:
	    return 8*sizeof(void *);
    }
}

cuex_t
cuex_typeof(cuex_t e)
{
    cuex_meta_t m = cuex_meta(e);
    switch (cuex_meta_kind(m)) {
	case cuex_meta_kind_type:
	    return cudyn_type_from_meta(m);
	case cuex_meta_kind_opr:
	    return cudyn_cuex_type();
	case cuex_meta_kind_other:
	    return cudyn_cuex_type();
	default:
	    cu_debug_unreachable();
    }
}

cuex_t cuexP_generic_ptr_type;

void
cuexP_type_init()
{
    cuexP_generic_ptr_type = cuex_o1(ptr_to, cudyn_singular_type());
}
