#include <stdio.h>
#include <stdarg.h>
#include <assert.h>
#include <cu/conf.h>
#include <cu/clos.h>
#include <cuflow/cont.h>
#ifdef CUCONF_HAVE_GC_GC_H
#  include <gc/gc.h>
#else
#  include <gc.h>
#endif

static int opt_decline = 0;

cu_clop_def0(thrower, void)
{
    printf("Throwing \"Take this\".\n");
    cuflow_throw("Take this.");
}

cu_clop_def0(relaxer, void)
{
    printf("I do nothing.\n");
}

cu_clop_def(catcher, void, char *xc)
{
    printf("Got exception \"%s\".  Accepting.\n", xc);
}

cu_clop_def(rethrower, void, char *xc)
{
    printf("Got exception \"%s\".  Rethrowing.\n", xc);
    cuflow_throw(xc);
    assert(!"Not reached.");
}

cu_clop_def(complainer, void, char *xc)
{
    assert(!"Not reached.");
}

cu_clop_def0(catch_and_rethrower, void)
{
    cuflow_catch(thrower,
		 (cu_clop(, void, void *))rethrower);
}

cu_clos_def(printer,
	    void cu_proto0(),
	    (char *str;))
{
    cu_clos_self(printer);
    printf(self->str);
}

cu_clos_def(winder,
	    void cu_proto0(),
	    (cu_clop0(trunk, void);))
{
    cu_clos_self(winder);
    printer_t pr0;
    printer_t pr1;
    cu_clos_cct(&pr0, printer);
    pr0.str = "Winding in.\n";
    cu_clos_cct(&pr1, printer);
    pr1.str = "Winding out.\n";
    cuflow_dynamic_wind(cu_clos_ref(&pr0), self->trunk,
		     cu_clos_ref(&pr1), cuflow_current_mode());
}

cu_clos_def(cc_setter,
	    void cu_proto0(),
	    ( int is_reentry;
	      cu_clop(cont, void, void *); ))
{
    cu_clos_self(cc_setter);
    printf("Saving current continuation.\n");
    cuflow_set_cc(&self->cont,
	       &self->is_reentry, sizeof(self->is_reentry));
    assert(!cu_clop_is_null(self->cont));
    printf("Leaving cc_setter: is_reentry = %d\n", self->is_reentry);
}

cu_clop0(mk_winder(cu_clop0(wound, void)), void)
{
    winder_t *cl = GC_malloc(sizeof(winder_t));
    cu_clos_cct(cl, winder);
    cl->trunk = wound;
    return cu_clos_ref(cl);
}

cu_clop_def0(alt_main, void)
{
    cc_setter_t *setcc;
    printf("Entering alt_main.\n");
    cuflow_catch(relaxer,
		 (cu_clop(, void, void *))complainer);
    cuflow_catch(thrower,
		 (cu_clop(, void, void *))catcher);
    cuflow_catch(catch_and_rethrower,
		 (cu_clop(, void, void *))(void *)catcher);
    cu_call0(mk_winder(relaxer));
    printf("Current flow is %s.\n", cuflow_mode_name(cuflow_current_mode()));
    cuflow_catch(mk_winder(thrower),
	      (cu_clop(, void, void *))catcher);

    setcc = GC_malloc(sizeof(cc_setter_t));
    cu_clos_cct(setcc, cc_setter);
    setcc->is_reentry = 0;
    setcc->cont = cu_clop_null;
    printf("Calling double winder.\n");
    cu_call0(mk_winder(mk_winder(cu_clos_ref(setcc))));
    if (setcc->is_reentry < 2) {
	int i = setcc->is_reentry + 1;
	printf("Reentering double winder.\n");
	assert(!cu_clop_is_null(setcc->cont));
	cu_call(setcc->cont, &i);
    }

    if (opt_decline) {
	cuflow_tstate()->opt_uncaught_backtrace = 1;
	cu_call0(mk_winder(thrower));
    }

    printf("Leaving alt_main.\n");
    cuflow_continuation_print_stats();
    exit(0);
}

int
main(int argc, char** argv)
{
    if (argc == 2)
	sscanf(argv[1], "%d", &opt_decline);
    cu_init();
    cu_call_in_root(alt_main, cuflow_mode_nondet);
    return 0;
}
