/*-*-C-*-
 * Copyright 2004  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cuflow/fwd.h>
#include <gc/gc.h>

void cu_init(void);
void cuflowP_wind_init(void);
void cuflowP_signal_init(void);
void cuflowP_gworkq_init(void);
#ifdef CUCONF_ENABLE_EXPERIMENTAL
void cuflowP_time_init(void);
void cuflowP_cntn_common_init(void);
#endif

void
cuflow_init()
{
    static int done_init = 0;
    if (done_init)
	return;
    done_init = 1;

    GC_INIT();
    cu_init();
    cuflowP_signal_init();
    cuflowP_gworkq_init();
#ifdef CUCONF_ENABLE_EXPERIMENTAL
    cuflowP_time_init();
    cuflowP_cntn_common_init();
#endif
}
