#include <cuflow/wind.h>
#include <cuflow/except.h>
#include <stdio.h>

cuflow_xc_extern(runtime_error,
	      cu_proto(char *what),
	      (char *what;));

cuflow_xc_define(runtime_error,
	      cu_proto(char *what))
{
    self->what = what;
}

void g(FILE *file, int i)
{
    if (i == 't')
	cuflow_throw(runtime_error, "Testing exceptions.");
}

int f(int i)
{
    FILE *file = fopen("/etc/hosts", "r");
    long filepos;
    fprintf(stderr, "Entering f.\n");
    cuflow_wind_gotos();
    g(file, i);
    fclose(file);
    fprintf(stderr, "Returning from f.");
    cuflow_wind_return(0);
rewind:
    fprintf(stderr, "Enter rewind label.\n");
    file = fopen("/etc/hosts", "r");
    fseek(file, filepos, SEEK_SET);
    cuflow_rewind_continue;
unwind:
    fprintf(stderr, "Enter unwind label.\n");
    filepos = ftell(file);
    fclose(file);
    cuflow_unwind_continue;
except:
    fprintf(stderr, "Enter except label.\n");
    /* A frame where an exception occured can not be rewound, so there
     * is no need to store the file position. */
    fclose(file);
    if (cuflow_xc_is(runtime_error)) {
	cuflow_xc_dcln(runtime_error);
	fprintf(stderr, "runtime_error: %s\n", xc->what);
	cuflow_wind_return(-1);
    }
    /* Also a cuflow_wind_cleanup exception is thrown when all
     * continuations containing a snapshot of this frame have been
     * garbage collected.  We don't need to catch it, since we already
     * did the cleanup above. */
    cuflow_except_continue;
}


int
main()
{
    cu_init();
    f('t');
    f('t');
    return 0;
}
