/*-*-C-*-
 * Copyright 2006  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cugra/fwd.h>
#include <bdd.h>

static void
bdd_error(int err)
{
    cu_bugf("BDD error %s", bdd_errstring(err));
}

void cugraP_graph_init(void);

void
cugra_init(void)
{
    static int done_init = 0;
    if (done_init)
	return;
    done_init = 1;

    cu_init();
    cugraP_graph_init();

    bdd_init(10000, 1000);
    bdd_error_hook(bdd_error);
    bdd_setcacheratio(10);
}
