#include <cuos/fs.h>
#include <cu/str.h>
#include <stdio.h>
#include <string.h>

int
main(int argc, char **argv)
{
    char buf[5];
    cu_init();
    if (argc != 2) {
	fprintf(stderr, "Usage: %s DENTRY_TO_REMOVE_RECURSIVELY\n", argv[0]);
	return 1;
    }
    printf("!!! Remove %s recursively? (type yes to confirm) !!!", argv[1]);
    fgets(buf, 5, stdin);
    if (strcmp(buf, "yes\n") == 0) {
	if (!cuos_remove_rec(cu_str_new_cstr(argv[1])))
	    return 1;
    }
    return 0;
}
