/*-*-C-*-
 * Copyright 2003  Petter Urkedal
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CUSTO_BINARY_IO_H
#define CUSTO_BINARY_IO_H

#include <cucon/fwd.h>
#include <stdint.h>
#include <stdio.h>

CU_BEGIN_DECLARATIONS

cu_bool_fast_t custo_fwrite_uintmax(uintmax_t i, FILE *file);
cu_bool_fast_t custo_fread_uintmax(uintmax_t *i, FILE *file);
cu_bool_fast_t custo_fwrite_intmax(intmax_t i, FILE *file);
cu_bool_fast_t custo_fread_intmax(intmax_t *i, FILE *file);

/* Serialisation of strings */
cu_bool_fast_t custo_fread_str_cct(cu_str_t str, FILE *file);
cu_str_t custo_fread_str_new(FILE *file);
cu_bool_fast_t custo_fwrite_str(cu_str_t str, FILE *file);

CU_END_DECLARATIONS

#endif
