#include <cutext/src.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>


void
copy_to_stdout(cutext_src_t src)
{
    static const size_t bufsize = 10;
    for (;;) {
	cutext_src_lookahead(src, bufsize);
	if (cutext_src_data_size(src) == 0)
	    break;
	write(1, cutext_src_data_start(src), cutext_src_data_size(src));
	cutext_src_advance(src, cutext_src_data_size(src));
    }
}

int
main()
{
    int fd = 0;
    cutext_src_t src;
    cutext_chenc_t chenc;

    cu_init();
    src = cutext_src_new(cutext_producer_new_read(fd));
    chenc = cutext_src_detect_chenc(src);
    fprintf(stderr, "chenc=%s\n", cutext_chenc_name(chenc));
    copy_to_stdout(src);
    return 0;
}
