#include <cutext/ucs4src.h>
#include <cucon/pmap.h>

cu_clop_def(print_prop, void, void const *key, void *value)
{
    cu_verbf(0, "%s = %S", (char const *)key, (cu_str_t)value);
}

int
main()
{
    cutext_producer_t producer;
    cutext_ucs4src_t ucs4src;
    cucon_pmap_t props;
    cu_init();
    producer = cutext_producer_new_read(0);
    ucs4src = cutext_ucs4src_new_detect(producer,
					cu_str_new_cstr("(stdin)"), 1, 0);
    props = cutext_ucs4src_properties(ucs4src);
    if (props)
	cucon_pmap_iter_ptr(props, print_prop);
    while (!cutext_ucs4src_is_eof(ucs4src)) {
	cutext_ucs4char_t ch = cutext_ucs4src_peek(ucs4src);
	cu_errf_at(cutext_ucs4src_sref(ucs4src), "%Uc 0x%x", ch, ch);
	cutext_ucs4src_advance(ucs4src, 1);
    }
    return 0;
}
